/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.message;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.base.IdTitled;
import org.bgerp.model.msg.Message;
import ru.bgcrm.dao.message.MessageTypeContactSaver;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@Bean(oldClasses={"ru.bgcrm.dao.message.MessageTypeContactSaverEmail"})
public class MessageTypeContactSaverEmail
extends MessageTypeContactSaver {
    private static final List<IdTitled> MODE_LIST = List.of(new IdTitled(0, "\u041d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c"), new IdTitled(1, "C\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c EMail"), new IdTitled(2, "C\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c EMail \u0434\u043e\u043c\u0435\u043d"));
    private int paramId;

    public MessageTypeContactSaverEmail(ConfigMap config) throws Exception {
        super(config);
        this.paramId = config.getInt("paramId", -1);
        if (this.paramId <= 0) {
            throw new BGMessageException("paramId not defined!", new Object[0]);
        }
    }

    @Override
    public List<IdTitled> getSaveModeList() {
        return MODE_LIST;
    }

    @Override
    public void saveContact(DynActionForm form, Connection con, Message message, Process process, int saveMode) throws Exception {
        ParameterEmailValue value;
        CommonObjectLink customerLink = Utils.getFirst(new ProcessLinkDAO(con).getObjectLinksWithType(process.getId(), "customer"));
        if (customerLink == null) {
            return;
        }
        String email = message.getFrom();
        String domainName = StringUtils.substringAfter((String)email, (String)"@");
        ParamValueDAO paramDao = new ParamValueDAO(con);
        SortedMap<Integer, ParameterEmailValue> currentValue = paramDao.getParamEmail(customerLink.getLinkObjectId(), this.paramId);
        boolean exists = false;
        Iterator<ParameterEmailValue> iterator = currentValue.values().iterator();
        while (iterator.hasNext() && !(exists = (value = iterator.next()).getValue().equals(email) || value.getValue().equals(domainName))) {
        }
        if (!exists) {
            paramDao.updateParamEmail(customerLink.getLinkObjectId(), this.paramId, 0, new ParameterEmailValue(saveMode == 1 ? email : domainName));
        }
    }
}

