/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.entities;

import ar.com.fdvs.dj.domain.BooleanExpression;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJBaseElement;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJGroupVariable
extends DJBaseElement {
    private static final long serialVersionUID = 10000L;
    private static final Log log = LogFactory.getLog(DJGroupVariable.class);
    private AbstractColumn columnToApplyOperation;
    private DJCalculation operation;
    private Style style;
    private DJValueFormatter valueFormatter;
    private BooleanExpression printWhenExpression;
    private CustomExpression valueExpression;
    private Class incrementerFactoryClass;
    private DJGroupLabel label;
    private String name;
    private DJGroup group;

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation, Style style) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
        this.style = style;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation, Style style, DJValueFormatter formatter) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
        this.style = style;
        this.valueFormatter = formatter;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, CustomExpression valueExpression) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.valueExpression = valueExpression;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, CustomExpression valueExpression, Style style) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.valueExpression = valueExpression;
        this.style = style;
    }

    public String getTextForValueFormatterExpression(String variableName) {
        String fieldsMap = ExpressionUtils.getTextForFieldsFromScriptlet();
        String parametersMap = ExpressionUtils.getTextForParametersFromScriptlet();
        String variablesMap = ExpressionUtils.getTextForVariablesFromScriptlet();
        String stringExpression = "(((" + DJValueFormatter.class.getName() + ")$P{" + variableName + "_vf}).evaluate( $V{" + variableName + "}, " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
        log.debug((Object)("Expression for DJValueFormatter = " + stringExpression));
        return stringExpression;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public AbstractColumn getColumnToApplyOperation() {
        return this.columnToApplyOperation;
    }

    public void setColumnToApplyOperation(AbstractColumn columnToApplyOperation) {
        this.columnToApplyOperation = columnToApplyOperation;
    }

    public DJCalculation getOperation() {
        return this.operation;
    }

    public void setOperation(DJCalculation operation) {
        this.operation = operation;
    }

    public DJValueFormatter getValueFormatter() {
        return this.valueFormatter;
    }

    public void setValueFormatter(DJValueFormatter valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    public DJGroupLabel getLabel() {
        return this.label;
    }

    public void setLabel(DJGroupLabel label) {
        this.label = label;
    }

    public static Log getLog() {
        return log;
    }

    public DJGroupVariable(AbstractColumn columnToApplyOperation, DJCalculation operation, Style style, DJValueFormatter valueFormatter, DJGroupLabel label) {
        this.columnToApplyOperation = columnToApplyOperation;
        this.operation = operation;
        this.style = style;
        this.valueFormatter = valueFormatter;
        this.label = label;
    }

    public void setPrintWhenExpression(BooleanExpression printWhenExpression) {
        this.printWhenExpression = printWhenExpression;
    }

    public BooleanExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public void setValueExpression(CustomExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public CustomExpression getValueExpression() {
        return this.valueExpression;
    }

    public void setIncrementerFactoryClass(Class incrementerFactoryClass) {
        this.incrementerFactoryClass = incrementerFactoryClass;
    }

    public Class getIncrementerFactoryClass() {
        return this.incrementerFactoryClass;
    }

    public void setGroup(DJGroup djGroup) {
        this.group = djGroup;
    }

    public DJGroup getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

