/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectiveReportBuilder
extends FastReportBuilder {
    private static final Log LOGGER = LogFactory.getLog(ReflectiveReportBuilder.class);

    public ReflectiveReportBuilder(Collection _data) {
        if (_data == null || _data.isEmpty()) {
            throw new IllegalArgumentException("Parameter _data is null or empty");
        }
        Object item = _data.iterator().next();
        try {
            this.addProperties(PropertyUtils.getPropertyDescriptors(item));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"", (Throwable)ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public ReflectiveReportBuilder(Collection _data, String[] _propertiesNames) {
        if (_data == null || _data.isEmpty()) {
            throw new IllegalArgumentException("Parameter _data is null or empty");
        }
        if (_propertiesNames == null || _propertiesNames.length == 0) {
            throw new IllegalArgumentException("Parameter _propertiesNames is null or empty");
        }
        Object item = _data.iterator().next();
        PropertyDescriptor[] properties = new PropertyDescriptor[_propertiesNames.length];
        try {
            for (int i = 0; i < _propertiesNames.length; ++i) {
                String propertiesName = _propertiesNames[i];
                properties[i] = PropertyUtils.getPropertyDescriptor(item, (String)propertiesName);
            }
            this.addProperties(properties);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"", (Throwable)ex);
        }
    }

    private void addProperties(PropertyDescriptor[] _properties) throws ColumnBuilderException, ClassNotFoundException {
        for (PropertyDescriptor property : _properties) {
            if (!ReflectiveReportBuilder.isValidProperty(property)) continue;
            this.addColumn(ReflectiveReportBuilder.getColumnTitle(property), property.getName(), property.getPropertyType().getName(), ReflectiveReportBuilder.getColumnWidth(property));
        }
        this.setUseFullPageWidth(true);
    }

    private static String getColumnTitle(PropertyDescriptor _property) {
        StringBuilder buffer = new StringBuilder();
        String name = _property.getName();
        buffer.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append(' ');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static boolean isValidProperty(PropertyDescriptor _property) {
        return !"class".equals(_property.getName()) && ReflectiveReportBuilder.isValidPropertyClass(_property);
    }

    private static boolean isValidPropertyClass(PropertyDescriptor _property) {
        Class<?> type = _property.getPropertyType();
        return Number.class.isAssignableFrom(type) || type == String.class || Date.class.isAssignableFrom(type) || type == Boolean.class;
    }

    private static int getColumnWidth(PropertyDescriptor _property) {
        Class<?> type = _property.getPropertyType();
        if (Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return 70;
        }
        if (type == Boolean.class) {
            return 10;
        }
        if (Number.class.isAssignableFrom(type)) {
            return 60;
        }
        if (type == String.class) {
            return 100;
        }
        if (Date.class.isAssignableFrom(type)) {
            return 50;
        }
        return 50;
    }
}

