/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.reactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionType;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class ReactionTypeEmoji
implements ReactionType {
    private static final String TYPE_FIELD = "type";
    private static final String EMOJI_FIELD = "emoji";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="emoji")
    @NonNull
    private String emoji;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.emoji.isEmpty()) {
            throw new TelegramApiValidationException("Emoji parameter can't be empty", this);
        }
        if (!EMOJI_FIELD.equals(this.type)) {
            throw new TelegramApiValidationException("Type must be \"emoji\"", this);
        }
    }

    private static String $default$type() {
        return EMOJI_FIELD;
    }

    public static ReactionTypeEmojiBuilder builder() {
        return new ReactionTypeEmojiBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactionTypeEmoji)) {
            return false;
        }
        ReactionTypeEmoji other = (ReactionTypeEmoji)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$emoji = this.getEmoji();
        String other$emoji = other.getEmoji();
        return !(this$emoji == null ? other$emoji != null : !this$emoji.equals(other$emoji));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReactionTypeEmoji;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $emoji = this.getEmoji();
        result = result * 59 + ($emoji == null ? 43 : $emoji.hashCode());
        return result;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getEmoji() {
        return this.emoji;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="emoji")
    public void setEmoji(@NonNull String emoji) {
        if (emoji == null) {
            throw new NullPointerException("emoji is marked non-null but is null");
        }
        this.emoji = emoji;
    }

    public String toString() {
        return "ReactionTypeEmoji(type=" + this.getType() + ", emoji=" + this.getEmoji() + ")";
    }

    public ReactionTypeEmoji() {
        this.type = ReactionTypeEmoji.$default$type();
    }

    public ReactionTypeEmoji(@NonNull String type, @NonNull String emoji) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (emoji == null) {
            throw new NullPointerException("emoji is marked non-null but is null");
        }
        this.type = type;
        this.emoji = emoji;
    }

    public static class ReactionTypeEmojiBuilder {
        private boolean type$set;
        private String type$value;
        private String emoji;

        ReactionTypeEmojiBuilder() {
        }

        @JsonProperty(value="type")
        public ReactionTypeEmojiBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @JsonProperty(value="emoji")
        public ReactionTypeEmojiBuilder emoji(@NonNull String emoji) {
            if (emoji == null) {
                throw new NullPointerException("emoji is marked non-null but is null");
            }
            this.emoji = emoji;
            return this;
        }

        public ReactionTypeEmoji build() {
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = ReactionTypeEmoji.$default$type();
            }
            return new ReactionTypeEmoji(type$value, this.emoji);
        }

        public String toString() {
            return "ReactionTypeEmoji.ReactionTypeEmojiBuilder(type$value=" + this.type$value + ", emoji=" + this.emoji + ")";
        }
    }
}

