/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.mobile.struts.action.open;

import java.util.ArrayList;
import java.util.Map;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.cache.UserCache;
import org.bgerp.cache.UserNewsCache;
import org.bgerp.dao.process.FilterEntryCounter;
import org.bgerp.event.client.NewsInfoEvent;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.model.process.queue.config.SavedFiltersConfig;
import ru.bgcrm.plugin.mobile.dao.MobileDAO;
import ru.bgcrm.plugin.mobile.model.Account;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/open/plugin/mobile/user")
public class UserAction
extends BaseAction {
    public ActionForward state(DynActionForm form, ConnectionSet conSet) throws Exception {
        form.setResponseType("json");
        String key = form.getParam("key");
        if (Utils.isBlankString(key)) {
            throw new IllegalArgumentException();
        }
        Account account = new MobileDAO(conSet.getConnection()).findAccount(key, "user");
        if (account == null) {
            throw new BGMessageException("Account isn't registered", new Object[0]);
        }
        NewsInfoEvent event = UserNewsCache.getUserEvent(conSet, account.getObjectId());
        form.setResponseData("news", event);
        ArrayList<Counter> counters = new ArrayList<Counter>();
        form.setResponseData("counters", counters);
        FilterEntryCounter counter = FilterEntryCounter.getInstance();
        SavedFiltersConfig config = UserCache.getUser(account.getObjectId()).getPers().getConfig(SavedFiltersConfig.class);
        Map<Integer, SavedFiltersConfig.SavedFilterSet> topFilters = config.getTopFilters();
        for (SavedFiltersConfig.SavedFilterSet topFilter : topFilters.values()) {
            Queue queue = ProcessQueueCache.getQueue(topFilter.getQueueId());
            int count = counter.parseUrlAndGetCountSync(queue, topFilter.getUrl(), form.getUser());
            Counter cnt = new Counter();
            cnt.title = topFilter.getTitle();
            cnt.color = topFilter.getColor();
            cnt.value = count;
            counters.add(cnt);
        }
        return this.json(conSet, form);
    }

    public static class Counter {
        public String title;
        public int value;
        public String color;
    }
}

