/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.wizard.base;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.util.Log;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.Wizard;
import ru.bgcrm.model.process.wizard.LinkCustomerStep;
import ru.bgcrm.model.process.wizard.base.Step;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.form.DynActionForm;

public class WizardData {
    private static final Log log = Log.getLog();
    private final Process process;
    private final DynActionForm form;
    private final User user;
    private final List<StepData<?>> stepDataList = new ArrayList();
    private final boolean allFilled;

    public WizardData(Connection con, DynActionForm form, Wizard wizard, Process process, List<Step> stepList) {
        this.process = process;
        this.form = form;
        this.user = form.getUser();
        boolean allFilled = true;
        for (Step step : stepList) {
            StepData<?> stepData = step.data(this);
            try {
                if (stepData == null) {
                    throw new BGException("For the step " + step.getTitle() + " was returned null StepData!", new Object[0]);
                }
                if (!stepData.check(con)) continue;
                this.stepDataList.add(stepData);
                if (stepData.isFilled(form, con)) continue;
                allFilled = false;
            }
            catch (Exception e) {
                log.error(e);
                allFilled = false;
            }
            break;
        }
        this.allFilled = allFilled;
    }

    public Process getProcess() {
        return this.process;
    }

    public DynActionForm getForm() {
        return this.form;
    }

    public User getUser() {
        return this.user;
    }

    public List<StepData<?>> getStepDataList() {
        return this.stepDataList;
    }

    public boolean isAllFilled() {
        return this.allFilled;
    }

    public Customer getLinkedCustomer() {
        Customer result = null;
        for (StepData<?> stepData : this.stepDataList) {
            if (!(stepData instanceof LinkCustomerStep.Data)) continue;
            LinkCustomerStep.Data scStepData = (LinkCustomerStep.Data)stepData;
            result = scStepData.getCustomer();
        }
        return result;
    }
}

