/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.facilities.TelegramHttpClientBuilder;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.updates.DeleteWebhook;
import org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.generics.WebhookBot;

public final class WebhookUtils {
    private static final ContentType TEXT_PLAIN_CONTENT_TYPE = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private WebhookUtils() {
    }

    public static void setWebhook(DefaultAbsSender bot, WebhookBot webhookBot, SetWebhook setWebhook) throws TelegramApiException {
        setWebhook.validate();
        DefaultBotOptions botOptions = bot.getOptions();
        try (CloseableHttpClient httpclient = TelegramHttpClientBuilder.build(botOptions);){
            String requestUrl = bot.getBaseUrl() + "setWebhook";
            RequestConfig requestConfig = botOptions.getRequestConfig();
            if (requestConfig == null) {
                requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
            }
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setConfig(requestConfig);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("url", WebhookUtils.getBotUrl(setWebhook, webhookBot), TEXT_PLAIN_CONTENT_TYPE);
            if (setWebhook.getMaxConnections() != null) {
                builder.addTextBody("max_connections", setWebhook.getMaxConnections().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (setWebhook.getAllowedUpdates() != null) {
                builder.addTextBody("allowed_updates", objectMapper.writeValueAsString((Object)setWebhook.getAllowedUpdates()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (setWebhook.getIpAddress() != null) {
                builder.addTextBody("ip_address", setWebhook.getIpAddress(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (setWebhook.getDropPendingUpdates() != null) {
                builder.addTextBody("drop_pending_updates", setWebhook.getDropPendingUpdates().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (setWebhook.getSecretToken() != null) {
                builder.addTextBody("secret_token", setWebhook.getSecretToken(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (setWebhook.getCertificate() != null) {
                InputFile webhookFile = setWebhook.getCertificate();
                if (webhookFile.getNewMediaFile() != null) {
                    builder.addBinaryBody("certificate", webhookFile.getNewMediaFile(), ContentType.TEXT_PLAIN, webhookFile.getMediaName());
                } else if (webhookFile.getNewMediaStream() != null) {
                    builder.addBinaryBody("certificate", webhookFile.getNewMediaStream(), ContentType.TEXT_PLAIN, webhookFile.getMediaName());
                }
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost, botOptions.getHttpContext());){
                String responseContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                Boolean result = setWebhook.deserializeResponse(responseContent);
                if (!result.booleanValue()) {
                    throw new TelegramApiRequestException("Error setting webhook:" + responseContent);
                }
            }
        }
        catch (JsonProcessingException e) {
            throw new TelegramApiRequestException("Error deserializing setWebhook method response", (Throwable)e);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error executing setWebook method", (Throwable)e);
        }
    }

    public static void clearWebhook(DefaultAbsSender bot) throws TelegramApiRequestException {
        try {
            boolean result = (Boolean)bot.execute((BotApiMethod)new DeleteWebhook());
            if (!result) {
                throw new TelegramApiRequestException("Error removing old webhook");
            }
        }
        catch (TelegramApiException e) {
            throw new TelegramApiRequestException("Error removing old webhook", (Throwable)e);
        }
    }

    private static String getBotUrl(SetWebhook setWebhook, WebhookBot webhookBot) {
        String externalUrl = setWebhook.getUrl();
        return WebhookUtils.getBotUrl(externalUrl, webhookBot.getBotPath());
    }

    private static String getBotUrl(String externalUrl, String botPath) {
        if (!externalUrl.endsWith("/")) {
            externalUrl = externalUrl + "/";
        }
        externalUrl = externalUrl + "callback";
        if (StringUtils.isNotEmpty((CharSequence)botPath)) {
            if (!botPath.startsWith("/")) {
                externalUrl = externalUrl + "/";
            }
            externalUrl = externalUrl + botPath;
        }
        return externalUrl;
    }
}

