/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.manager.event.ManagerEvent;

public class ChannelReloadEvent
extends ManagerEvent {
    private static final long serialVersionUID = 1L;
    public static final String REASON_LOAD = "LOAD";
    public static final String REASON_RELOAD = "RELOAD";
    public static final String REASON_CLI_RELOAD = "CLIRELOAD";
    public static final String REASON_MANAGER_RELOAD = "MANAGERRELOAD";
    private static final Pattern REASON_PATTERN = Pattern.compile("^([A-Z]+) \\((.*)\\)$");
    private String channelType;
    private String reloadReason;
    private String reloadReasonCode;
    private String reloadReasonDescription;
    private Integer registryCount;
    private Integer peerCount;
    private Integer userCount;

    public ChannelReloadEvent(Object source) {
        super(source);
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    @Deprecated
    public String getChannel() {
        return this.channelType;
    }

    public void setChannel(String channel) {
        this.channelType = channel;
    }

    public Integer getPeerCount() {
        return this.peerCount;
    }

    public void setPeerCount(Integer peerCount) {
        this.peerCount = peerCount;
    }

    public Integer getRegistryCount() {
        return this.registryCount;
    }

    public void setRegistryCount(Integer registryCount) {
        this.registryCount = registryCount;
    }

    public String getReloadReason() {
        return this.reloadReason;
    }

    public void setReloadReason(String reloadReason) {
        this.reloadReason = reloadReason;
        if (reloadReason == null) {
            return;
        }
        Matcher matcher = REASON_PATTERN.matcher(reloadReason);
        if (matcher.matches()) {
            this.reloadReasonCode = matcher.group(1);
            this.reloadReasonDescription = matcher.group(2);
        }
    }

    public String getReloadReasonCode() {
        return this.reloadReasonCode;
    }

    public String getReloadReasonDescription() {
        return this.reloadReasonDescription;
    }

    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }
}

