/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.asteriskjava.live.AsteriskServer;
import org.asteriskjava.live.LiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

abstract class AbstractLiveObject
extends Lockable
implements LiveObject {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final PropertyChangeSupport changes;
    protected final AsteriskServerImpl server;
    private long lastUpdate;

    AbstractLiveObject(AsteriskServerImpl server) {
        this.server = server;
        this.changes = new PropertyChangeSupport(this);
        this.stampLastUpdate();
    }

    @Override
    public AsteriskServer getServer() {
        return this.server;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        boolean haveToAdd = true;
        for (PropertyChangeListener l : this.changes.getPropertyChangeListeners()) {
            if (l != listener) continue;
            haveToAdd = false;
            break;
        }
        if (haveToAdd) {
            this.changes.addPropertyChangeListener(propertyName, listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null || newValue != null) {
            this.stampLastUpdate();
            try {
                this.changes.firePropertyChange(propertyName, oldValue, newValue);
            }
            catch (Exception e) {
                this.logger.warn("Uncaught exception in PropertyChangeListener", e);
            }
        }
    }

    @Override
    public long getLastUpdateMillis() {
        return this.lastUpdate;
    }

    public void stampLastUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }
}

