/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;

public class MapUtils {
    public static final String MAP_API_SCRIPT = "net/sf/jasperreports/components/map/resources/scripts/jasperreportsMapApi.js";
    public static final String EXTERNAL_SCRIPT_LOAD_API_SCRIPT = "net/sf/jasperreports/components/map/resources/scripts/externalScriptLoadApi.js";
    public static final String OVERLAPPING_MARKER_SPIDERFIER_SCRIPT = "net/sf/jasperreports/components/map/resources/scripts/oms_1.0.3.js";

    public static String getSimplifiedMapConfig(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("mapCanvasId", "map_canvas_" + element.hashCode());
        MapUtils.prepareContextForVelocityTemplate(contextMap, jasperReportsContext, element);
        contextMap.put("googleMapsApiUrl", "");
        contextMap.put("markerClustererApiUrl", "");
        contextMap.put("jasperreportsMapApiScriptLocation", "");
        contextMap.put("overlappingMarkerSpiderfierApiScriptLocation", "");
        return VelocityUtil.processTemplate("net/sf/jasperreports/components/map/resources/templates/MapElementJsonTemplate.vm", contextMap);
    }

    public static void prepareContextForVelocityTemplate(Map<String, Object> velocityContext, JasperReportsContext jasperReportsContext, JRGenericPrintElement element) {
        JacksonUtil jacksonUtil = JacksonUtil.getInstance(jasperReportsContext);
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapComponent.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapComponent.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapComponent.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        mapType = (mapType == null ? MapComponent.DEFAULT_MAP_TYPE.getName() : mapType).toLowerCase();
        String mapId = (String)element.getParameterValue("mapId");
        mapId = mapId == null ? "DEMO_MAP_ID" : mapId;
        Boolean markerClustering = (Boolean)element.getParameterValue("markerClustering");
        markerClustering = markerClustering != null ? markerClustering : false;
        Boolean markerSpidering = (Boolean)element.getParameterValue("markerSpidering");
        markerSpidering = markerSpidering != null ? markerSpidering : false;
        velocityContext.put("latitude", latitude);
        velocityContext.put("longitude", longitude);
        velocityContext.put("zoom", zoom);
        velocityContext.put("mapType", mapType);
        velocityContext.put("mapId", mapId);
        velocityContext.put("useMarkerClustering", markerClustering);
        velocityContext.put("useMarkerSpidering", markerSpidering);
        Map legendPropertiesParam = (Map)element.getParameterValue("legendProperties");
        String legendProperties = legendPropertiesParam == null ? "{}" : jacksonUtil.getIndentedJsonString(legendPropertiesParam);
        velocityContext.put("legendProperties", legendProperties);
        Map resetMapPropertiesParam = (Map)element.getParameterValue("resetMapProperties");
        String resetMapProperties = resetMapPropertiesParam == null ? "{}" : jacksonUtil.getIndentedJsonString(resetMapPropertiesParam);
        velocityContext.put("resetMapProperties", resetMapProperties);
        Map markerSeries = (Map)element.getParameterValue("markers");
        String markers = markerSeries == null || markerSeries.isEmpty() ? "{}" : jacksonUtil.getIndentedJsonString(markerSeries);
        velocityContext.put("markerList", markers);
        List pathList = (List)element.getParameterValue("paths");
        String paths = pathList == null || pathList.isEmpty() ? "[]" : jacksonUtil.getIndentedJsonString(pathList);
        velocityContext.put("pathsList", paths);
        String defaultMarkerIcon = (String)element.getParameterValue("defaultMarkerIcon");
        velocityContext.put("defaultMarkerIcon", defaultMarkerIcon != null ? defaultMarkerIcon : "");
    }

    public static void addExternalURLs(Map<String, Object> velocityContext, JRGenericPrintElement element) {
        String reqParams = (String)element.getParameterValue("reqParams");
        String googleMapsApiUrl = "https://maps.googleapis.com/maps/api/js";
        if (reqParams != null) {
            googleMapsApiUrl = googleMapsApiUrl + "?" + reqParams;
        }
        velocityContext.put("googleMapsApiUrl", googleMapsApiUrl);
        velocityContext.put("markerClustererApiUrl", "https://unpkg.com/@googlemaps/markerclusterer/dist/index.min.js");
    }
}

