/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.util.Utils;

public class PrintQueueConfig
extends Config {
    private LinkedHashMap<Integer, PrintType> printTypes = new LinkedHashMap();

    public PrintQueueConfig(ConfigMap config) {
        super(null);
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("media.print.").entrySet()) {
            PrintType type = new PrintType((int)me.getKey(), me.getValue());
            this.printTypes.put(type.getId(), type);
        }
    }

    public Collection<PrintType> getPrintTypes() {
        return this.printTypes.values();
    }

    public PrintType getPrintType(int id) {
        return this.printTypes.get(id);
    }

    public static class PrintType
    extends IdTitle {
        public static final String TYPE_PDF = "pdf";
        public static final String ORIENTATION_PORTRAIT = "portrait";
        public static final String ORIENTATION_LANDSCAPE = "landscape";
        private final String type;
        private final String orientation;
        private final String fileName;
        private final List<String> columnIds = new ArrayList<String>();
        private final List<Integer> columnWidths = new ArrayList<Integer>();

        private PrintType(int id, ConfigMap config) {
            super(id, config.get("title"));
            this.type = config.get("type", TYPE_PDF);
            this.orientation = config.get("orientation", ORIENTATION_PORTRAIT);
            this.fileName = config.get("fileName", "bgerp_process_queue.pdf");
            for (String pair : Utils.toList(config.get("columns"))) {
                String[] tokens = pair.split(":");
                if (tokens.length != 2) continue;
                this.columnIds.add(tokens[0]);
                this.columnWidths.add(Utils.parseInt(tokens[1]));
            }
        }

        public String getType() {
            return this.type;
        }

        public String getOrientation() {
            return this.orientation;
        }

        public String getFileName() {
            return this.fileName;
        }

        public List<String> getColumnIds() {
            return this.columnIds;
        }

        public List<Integer> getColumnWidths() {
            return this.columnWidths;
        }
    }
}

