/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.param;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.expression.ParamExpressionObject;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import org.bgerp.util.text.PatternFormatter;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.util.Utils;

public class ParameterAddressValue {
    private int houseId = -1;
    private String flat = "";
    private String room = "";
    private int pod = -1;
    private Integer floor;
    private String comment = "";
    private AddressHouse house;
    private String value;

    public int getHouseId() {
        return this.houseId;
    }

    public void setHouseId(int houseId) {
        this.houseId = houseId;
    }

    public ParameterAddressValue withHouseId(int houseId) {
        this.setHouseId(houseId);
        return this;
    }

    public String getFlat() {
        return this.flat;
    }

    public void setFlat(String flat) {
        this.flat = flat;
    }

    public ParameterAddressValue withFlat(String flat) {
        this.setFlat(flat);
        return this;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public int getPod() {
        return this.pod;
    }

    public void setPod(int pod) {
        this.pod = pod;
    }

    public Integer getFloor() {
        return this.floor;
    }

    public void setFloor(Integer value) {
        this.floor = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public AddressHouse getHouse() {
        return this.house;
    }

    public void setHouse(AddressHouse house) {
        this.house = house;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String formatValue(Connection con) throws SQLException {
        return this.formatValue(con, null);
    }

    public String formatValue(Connection con, String formatName) throws SQLException {
        if (this.house == null) {
            this.house = new AddressDAO(con).getAddressHouse(this.houseId, true, true, true);
            if (this.house == null) {
                throw new BGException("House not found: " + this.houseId, new Object[0]);
            }
        }
        String pattern = Setup.getSetup().get("address.format", "(${street})(, ${house})(, ${floor} floor)(, apt. ${flat})( ${room})( ${comment})( ${index})( ${city})( [${comment}])");
        if (Utils.notBlankString(formatName)) {
            pattern = Setup.getSetup().get("address.format." + formatName, pattern);
        }
        String result = PatternFormatter.processPattern(pattern, variable -> {
            if ("index".equals(variable)) {
                return this.house.getPostIndex();
            }
            if ("city".equals(variable)) {
                return this.house.getAddressStreet().getAddressCity().getTitle();
            }
            if ("area".equals(variable)) {
                return this.house.getAddressArea().getTitle();
            }
            if ("quarter".equals(variable)) {
                return this.house.getAddressQuarter().getTitle();
            }
            if ("street".equals(variable)) {
                return this.house.getAddressStreet().getTitle();
            }
            if ("house".equals(variable)) {
                return this.house.getHouseAndFrac();
            }
            if ("flat".equals(variable)) {
                return this.flat;
            }
            if ("room".equals(variable)) {
                return this.room;
            }
            if ("pod".equals(variable)) {
                return this.pod > 0 ? String.valueOf(this.pod) : "";
            }
            if ("floor".equals(variable)) {
                return this.floor == null ? "" : String.valueOf(this.floor);
            }
            if ("comment".equals(variable)) {
                return this.comment;
            }
            if (variable.startsWith("param_")) {
                if (con == null) {
                    throw new BGException("Can't use ${param_<ID>} variables with con=null", new Object[0]);
                }
                Parameter p = ParameterCache.getParameter(Utils.parseInt(StringUtils.substringAfter((String)variable, (String)"_")));
                if (p == null) {
                    throw new BGException("Not found parameter for variable: " + variable, new Object[0]);
                }
                if (!"address_house".equals(p.getObjectType())) {
                    throw new BGException(Log.format("Object type for parameter '{}' must be '{}'", variable, "address_house"), new Object[0]);
                }
                return new ParamExpressionObject(con, this.houseId).val(p.getId());
            }
            return "";
        });
        return result;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParameterAddressValue)) {
            return false;
        }
        ParameterAddressValue addressValue = (ParameterAddressValue)object;
        if (this.houseId != addressValue.houseId) {
            return false;
        }
        if (!Utils.maskNull(this.flat).equals(Utils.maskNull(addressValue.flat))) {
            return false;
        }
        return Utils.maskNull(this.room).equals(Utils.maskNull(addressValue.room));
    }
}

