/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.util.Log;
import ru.bgcrm.util.sql.SQLUtils;

public class TableChangeMonitor
extends Thread {
    private static final Log log = Log.getLog();
    private static final TableChangeMonitor INSTANCE = new TableChangeMonitor();
    private static final long CHECK_PERIOD = 60000L;
    private Map<String, Map<String, Runnable>> subscriberMap = new ConcurrentHashMap<String, Map<String, Runnable>>();
    private Map<String, String> rowCounts = new HashMap<String, String>();

    public static void subscribeOnChange(String subscriptionPoint, String tableName, Runnable callback) {
        Map<String, Runnable> tablesMap = TableChangeMonitor.INSTANCE.subscriberMap.get(subscriptionPoint);
        if (tablesMap == null) {
            tablesMap = new ConcurrentHashMap<String, Runnable>();
            TableChangeMonitor.INSTANCE.subscriberMap.put(subscriptionPoint, tablesMap);
        }
        tablesMap.put(tableName, callback);
    }

    private TableChangeMonitor() {
        this.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Connection con = Setup.getSetup().getDBConnectionFromPool();
                HashMap<String, ArrayList<Runnable>> runnableMap = new HashMap<String, ArrayList<Runnable>>();
                for (Map.Entry<String, Map<String, Runnable>> me : this.subscriberMap.entrySet()) {
                    for (Map.Entry<String, Runnable> rme : me.getValue().entrySet()) {
                        String tableName = rme.getKey();
                        Runnable callback = rme.getValue();
                        ArrayList<Runnable> runList = (ArrayList<Runnable>)runnableMap.get(tableName);
                        if (runList == null) {
                            runList = new ArrayList<Runnable>();
                            runnableMap.put(tableName, runList);
                        }
                        runList.add(callback);
                    }
                }
                for (String tableName : runnableMap.keySet()) {
                    String count;
                    String prevCount;
                    String query = "SELECT COUNT(*) FROM " + tableName;
                    PreparedStatement ps = con.prepareStatement(query);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next() && (prevCount = this.rowCounts.put(tableName, count = rs.getString(1))) != null && !prevCount.equals(count)) {
                        log.debug("Table changed: {}", tableName);
                        List runnableList = (List)runnableMap.get(tableName);
                        for (Runnable r : runnableList) {
                            r.run();
                        }
                    }
                    ps.close();
                }
                SQLUtils.closeConnection(con);
                TableChangeMonitor.sleep(60000L);
            }
        }
        catch (Exception e) {
            log.error(e);
            return;
        }
    }
}

