/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.action.admin;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.callboard.cache.CallboardCache;
import org.bgerp.plugin.pln.callboard.dao.ShiftDAO;
import org.bgerp.plugin.pln.callboard.dao.WorkTypeDAO;
import org.bgerp.plugin.pln.callboard.model.Shift;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import org.bgerp.plugin.pln.callboard.model.WorkTypeTime;
import org.bgerp.plugin.pln.callboard.model.config.ShortcutConfig;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@ActionServlet.Action(path="/admin/plugin/callboard/work")
public class WorkAction
extends org.bgerp.plugin.pln.callboard.action.WorkAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/plugin/callboard";

    public ActionForward workTypeList(DynActionForm form, Connection con) throws Exception {
        int categoryId = form.getParamInt("categoryId", 0);
        form.setRequestAttribute("allowOnlyCategories", this.getAvailableCategories(form.getPermission()));
        new WorkTypeDAO(con).searchWorkType(new Pageable<WorkType>(form), categoryId);
        return this.html(con, form, "/WEB-INF/jspf/admin/plugin/callboard/type/list.jsp");
    }

    public ActionForward workTypeGet(DynActionForm form, Connection con) throws Exception {
        int paramater = Setup.getSetup().getInt("callboard.serviceListId", 0);
        WorkType workType = new WorkTypeDAO(con).getWorkType(form.getId());
        HttpServletRequest request = form.getHttpRequest();
        if (paramater > 0) {
            request.setAttribute("servicesList", ParameterCache.getParameter(paramater).getListParamValues());
        }
        if (workType != null) {
            form.setResponseData("workType", workType);
        }
        request.setAttribute("shortcutMap", this.setup.getConfig(ShortcutConfig.class).getShortcutMap());
        request.setAttribute("allowOnlyCategories", this.getAvailableCategories(form.getPermission()));
        return this.html(con, form, "/WEB-INF/jspf/admin/plugin/callboard/type/update.jsp");
    }

    public ActionForward workTypeUpdate(DynActionForm form, Connection con) throws Exception {
        if (form.getParam("title").length() == 0) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0440\u0430\u0431\u043e\u0442", new Object[0]);
        }
        int category = form.getParamInt("categoryId", 0);
        HashSet<Integer> allowCategorySet = new HashSet<Integer>();
        for (IdTitle idTitle : this.getAvailableCategories(form.getPermission())) {
            allowCategorySet.add(idTitle.getId());
        }
        if (!allowCategorySet.contains(category)) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f, \u043b\u0438\u0431\u043e \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", new Object[0]);
        }
        WorkType workType = null;
        if (form.getId() > 0) {
            workType = new WorkTypeDAO(con).getWorkType(form.getId());
            if (workType == null) {
                throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432 \u0411\u0414 \u0442\u0438\u043f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 ID=" + form.getId(), new Object[0]);
            }
        } else {
            workType = new WorkType();
        }
        workType.setCategory(category);
        workType.setTitle(form.getParam("title"));
        workType.setComment(form.getParam("comment"));
        workType.setColor(form.getParam("color"));
        workType.setShortcutList(Utils.toList(form.getParam("shortcuts", "")));
        workType.setTimeSetStep(form.getParamInt("timeSetStep"));
        workType.setTimeSetMode(form.getParamInt("timeSetMode"));
        workType.setNonWorkHours(form.getParamBoolean("nonWorkHours", false));
        workType.setRuleConfig(form.getParam("ruleConfig"));
        new WorkTypeDAO(con).updateWorkType(workType);
        CallboardCache.flush(con);
        return this.html(con, form, "/WEB-INF/jspf/admin/plugin/callboard/type/list.jsp");
    }

    public ActionForward workTypeDelete(DynActionForm form, Connection con) throws Exception {
        new WorkTypeDAO(con).deleteWorkType(form.getId());
        CallboardCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward shiftList(DynActionForm form, Connection con) throws Exception {
        int categoryId = form.getParamInt("categoryId", 0);
        form.setRequestAttribute("allowOnlyCategories", this.getAvailableCategories(form.getPermission()));
        new ShiftDAO(con).searchShift(new Pageable<Shift>(form), categoryId);
        return this.html(con, form, "/WEB-INF/jspf/admin/plugin/callboard/shift/list.jsp");
    }

    public ActionForward shiftGet(DynActionForm form, Connection con) throws Exception {
        HashMap<Integer, WorkType> workTypeMap = new HashMap<Integer, WorkType>();
        Set<Integer> categoryIds = this.getAvailableCategoryIds(form.getPermission());
        for (Map.Entry<Integer, WorkType> entry : CallboardCache.getWorkTypeMap().entrySet()) {
            if (!categoryIds.contains(entry.getValue().getCategory())) continue;
            workTypeMap.put(entry.getKey(), entry.getValue());
        }
        Shift shift = new ShiftDAO(con).getShift(form.getId());
        if (shift != null) {
            form.setResponseData("shift", shift);
            form.setResponseData("workTypeMap", workTypeMap);
        }
        form.setRequestAttribute("allowOnlyCategories", this.getAvailableCategories(form.getPermission()));
        form.setResponseData("workTypeList", new ArrayList(workTypeMap.values()));
        return this.html(con, form, "/WEB-INF/jspf/admin/plugin/callboard/shift/update.jsp");
    }

    public ActionForward shiftUpdate(DynActionForm form, Connection con) throws Exception {
        if (form.getParam("title").length() == 0) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u0441\u043c\u0435\u043d\u044b", new Object[0]);
        }
        int category = form.getParamInt("categoryId", 0);
        String symbol = form.getParam("symbol", "");
        Set<Integer> allowCategorySet = this.getAvailableCategoryIds(form.getPermission());
        if (!allowCategorySet.contains(category)) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f, \u043b\u0438\u0431\u043e \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", new Object[0]);
        }
        boolean useOwnColor = form.getParamValues("useOwnColor").size() > 0;
        String color = form.getParam("color", "");
        ArrayList<WorkTypeTime> ruleList = new ArrayList<WorkTypeTime>();
        try {
            for (String item : form.getParam().getArray("rule")) {
                WorkTypeTime workTypeTime = new WorkTypeTime();
                String[] tokens = item.split(":");
                if (tokens.length < 3) continue;
                workTypeTime.setWorkTypeId(Utils.parseInt(tokens[0]));
                workTypeTime.setDayMinuteFrom(Utils.parseInt(tokens[1]));
                workTypeTime.setDayMinuteTo(Utils.parseInt(tokens[2]));
                ruleList.add(workTypeTime);
            }
        }
        catch (Exception e) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0440\u0430\u0431\u043e\u0442", new Object[0]);
        }
        Shift shift = form.getId() > 0 ? new ShiftDAO(con).getShift(form.getId()) : new Shift();
        shift.setWorkTypeTimeList(ruleList);
        shift.setTitle(form.getParam("title"));
        shift.setCategory(category);
        shift.setUseOwnColor(useOwnColor);
        shift.setColor(color);
        shift.setSymbol(symbol);
        new ShiftDAO(con).updateShift(shift);
        return this.html(con, form, "/WEB-INF/jspf/admin/plugin/callboard/shift/list.jsp");
    }

    public ActionForward shiftDelete(DynActionForm form, Connection con) throws Exception {
        new ShiftDAO(con).deleteShift(form.getId());
        return this.json(con, form);
    }
}

