/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.Dynamic;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.util.Utils;

public class ProcessGroups
extends TreeSet<ProcessGroup> {
    public static ProcessGroups of(String[] array) {
        ProcessGroups result = new ProcessGroups();
        if (array == null) {
            return result;
        }
        if (array != null) {
            for (String item : array) {
                ProcessGroup processGroup = new ProcessGroup();
                if (item.indexOf(":") > -1) {
                    processGroup.setGroupId(Utils.parseInt(item.substring(0, item.indexOf(":"))));
                    processGroup.setRoleId(Utils.parseInt(item.substring(item.indexOf(":") + 1)));
                } else {
                    processGroup.setGroupId(Utils.parseInt(item));
                    processGroup.setRoleId(0);
                }
                result.add(processGroup);
            }
        }
        return result;
    }

    public static ProcessGroups of(List<IdTitle> list) {
        ProcessGroups result = new ProcessGroups();
        for (IdTitle item : list) {
            ProcessGroup processGroup = new ProcessGroup();
            processGroup.setGroupId(item.getId());
            processGroup.setRoleId(Utils.parseInt(item.getTitle()));
            result.add(processGroup);
        }
        return result;
    }

    public ProcessGroups() {
    }

    public ProcessGroups(Set<ProcessGroup> groups) {
        super(groups);
    }

    public ProcessGroups(Integer ... groupId) {
        super(Stream.of(groupId).map(id -> new ProcessGroup((int)id)).collect(Collectors.toSet()));
    }

    public Set<Integer> getGroupIds() {
        return this.stream().map(ProcessGroup::getGroupId).collect(Collectors.toSet());
    }

    public Set<Integer> getRoleIds() {
        return this.stream().map(ProcessGroup::getRoleId).collect(Collectors.toSet());
    }

    @Dynamic
    public Set<String> getGroupRoleIds() {
        return this.stream().map(ProcessGroup::toGroupRolePair).collect(Collectors.toSet());
    }
}

