/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class Highlighter {
    public static Highlighter LOG_WARN = new Highlighter("*.warn.log"){

        @Override
        protected boolean hasError(String line) {
            return true;
        }
    };
    public static Highlighter LOG_UPDATE_EXCEPTION = new Highlighter("update_*.log"){

        @Override
        protected boolean hasError(String line) {
            return line.contains("ERROR") || line.contains("REMOVE SOON");
        }
    };
    private final FileFilter fileFilter;

    private Highlighter(String wildcard) {
        this.fileFilter = new WildcardFileFilter(wildcard);
    }

    public boolean match(File file) {
        return this.fileFilter.accept(file);
    }

    public String highlight(File file) throws FileNotFoundException {
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!this.hasError(line)) continue;
                String string = "error";
                return string;
            }
        }
        return null;
    }

    protected boolean hasError(String line) {
        return false;
    }
}

