<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/taglibs.jsp"%>

<c:set var="news" value="${frd.news}"/>

<form id="newsCreateForm" class="center1020" action="/user/news.do" method="post" name="dynForm" onsubmit="return false;">
	<input type="hidden" name="method" value="newsUpdate" />
	<input type="hidden" name="id" value="${news.id}" />

	<c:if test="${form.param.requestUserId > 0}">
		<input type="hidden" name="requestUserId" value="${form.param.requestUserId}" />
	</c:if>

	<h2>${l.l('Заголовок')}</h2>
	<input type="text" name="title" style="width: 100%;" value="${news.title}"/>
	<h2>${l.l('Текст')}&nbsp;${isMsg == 1 ? l.l('of message') : l.l('of news')}</h2>
	<textarea style="width: 100%;" rows="10" name="description"></textarea>
	<span class="hint">${l.l('В тексте новости допустима HTML разметка.')}</span>

	<div>
		<div style="width: 50%; display: inline-block;">
			<h2>${l.l('Время на прочтение')}</h2>
			<input type="text" name="readTime" value="${not empty news ? news.readTime : 240}" style="text-align: center; width: 102px;"/>
			<span class="hint">${l.l('Через какое количество часов новость будет помечена прочитана для адресатов независимо от фактического прочтения.')}</span>

			<h2>${l.l('Время жизни новости')}</h2>
			<input type="text" name="lifeTime" value="${not empty news ? news.lifeTime : 300}" style="text-align: center; width: 102px;"/>
			<span class="hint">${l.l('Через какое количество суток новость будет удалена для всех адресатов.')}</span>

			<h2>${l.l('Тип новости')}</h2>
			<ui:combo-single style="width: 150px;" hiddenName="type">
				<jsp:attribute name="valuesHtml">
					<li value="-1">${l.l('----')}</li>
					<li value="0">${l.l('Обычная')}</li>
					<li value="1">${l.l('Всплывающая')}</li>
				</jsp:attribute>
			</ui:combo-single>
		 </div><%--
	 --%><div style="width: 50%; display: inline-block; vertical-align: top;">
	 		<c:if test="${not(form.param.requestUserId > 0 )}">
				<h2>${l.l('Groups')}</h2>

				<ui:select-mult list="${ctxUserGroupList}" hiddenName="group" values="${news.groupIds}" style="width: 100%;"/>

				<span class="hint">${l.l('Если группы не указаны - новость получают все пользователи.')}</span>
			</c:if>
		</div>
	</div>

	<ui:form-ok-cancel styleClass="mt1"/>
</form>

<shell:state text="${l.l('Создание новости')}"/>