/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.invoices;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.payments.LabeledPrice;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class CreateInvoiceLink
extends BotApiMethod<String> {
    public static final String PATH = "createInvoiceLink";
    public static final String TITLE_FIELD = "title";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PAYLOAD_FIELD = "payload";
    public static final String PROVIDER_TOKEN_FIELD = "provider_token";
    public static final String CURRENCY_FIELD = "currency";
    public static final String PRICES_FIELD = "prices";
    public static final String MAXTIPAMOUNT_FIELD = "max_tip_amount";
    public static final String SUGGESTEDTIPAMOUNTS_FIELD = "suggested_tip_amounts";
    public static final String PROVIDER_DATA_FIELD = "provider_data";
    public static final String PHOTO_URL_FIELD = "photo_url";
    public static final String PHOTO_SIZE_FIELD = "photo_size";
    public static final String PHOTO_WIDTH_FIELD = "photo_width";
    public static final String PHOTO_HEIGHT_FIELD = "photo_height";
    public static final String NEED_NAME_FIELD = "need_name";
    public static final String NEED_PHONE_NUMBER_FIELD = "need_phone_number";
    public static final String NEED_EMAIL_FIELD = "need_email";
    public static final String NEED_SHIPPING_ADDRESS_FIELD = "need_shipping_address";
    public static final String SEND_PHONE_NUMBER_TO_PROVIDER_FIELD = "send_phone_number_to_provider";
    public static final String SEND_EMAIL_TO_PROVIDER_FIELD = "send_email_to_provider";
    public static final String IS_FLEXIBLE_FIELD = "is_flexible";
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="description")
    @NonNull
    private String description;
    @JsonProperty(value="payload")
    @NonNull
    private String payload;
    @JsonProperty(value="provider_token")
    @NonNull
    private String providerToken;
    @JsonProperty(value="currency")
    @NonNull
    private String currency;
    @JsonProperty(value="prices")
    @NonNull
    private List<LabeledPrice> prices;
    @JsonProperty(value="photo_url")
    private String photoUrl;
    @JsonProperty(value="photo_size")
    private Integer photoSize;
    @JsonProperty(value="photo_width")
    private Integer photoWidth;
    @JsonProperty(value="photo_height")
    private Integer photoHeight;
    @JsonProperty(value="need_name")
    private Boolean needName;
    @JsonProperty(value="need_phone_number")
    private Boolean needPhoneNumber;
    @JsonProperty(value="need_email")
    private Boolean needEmail;
    @JsonProperty(value="need_shipping_address")
    private Boolean needShippingAddress;
    @JsonProperty(value="is_flexible")
    private Boolean isFlexible;
    @JsonProperty(value="send_phone_number_to_provider")
    private Boolean sendPhoneNumberToProvider;
    @JsonProperty(value="send_email_to_provider")
    private Boolean sendEmailToProvider;
    @JsonProperty(value="provider_data")
    private String providerData;
    @JsonProperty(value="max_tip_amount")
    private Integer maxTipAmount;
    @JsonProperty(value="suggested_tip_amounts")
    private List<Integer> suggestedTipAmounts;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (Strings.isNullOrEmpty((String)this.title) || this.title.length() > 32) {
            throw new TelegramApiValidationException("Title parameter can't be empty or longer than 32 chars", this);
        }
        if (Strings.isNullOrEmpty((String)this.description) || this.description.length() > 255) {
            throw new TelegramApiValidationException("Description parameter can't be empty or longer than 255 chars", this);
        }
        if (Strings.isNullOrEmpty((String)this.payload)) {
            throw new TelegramApiValidationException("Payload parameter can't be empty", this);
        }
        if (Strings.isNullOrEmpty((String)this.providerToken)) {
            throw new TelegramApiValidationException("ProviderToken parameter can't be empty", this);
        }
        if (Strings.isNullOrEmpty((String)this.currency)) {
            throw new TelegramApiValidationException("Currency parameter can't be empty", this);
        }
        if (this.prices.isEmpty()) {
            throw new TelegramApiValidationException("Prices parameter can't be empty", this);
        }
        for (LabeledPrice price : this.prices) {
            price.validate();
        }
        if (this.suggestedTipAmounts != null && !this.suggestedTipAmounts.isEmpty() && this.suggestedTipAmounts.size() > 4) {
            throw new TelegramApiValidationException("No more that 4 suggested tips allowed", this);
        }
    }

    @Override
    public String deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, String.class);
    }

    public static CreateInvoiceLinkBuilder builder() {
        return new CreateInvoiceLinkBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateInvoiceLink)) {
            return false;
        }
        CreateInvoiceLink other = (CreateInvoiceLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$photoSize = this.getPhotoSize();
        Integer other$photoSize = other.getPhotoSize();
        if (this$photoSize == null ? other$photoSize != null : !((Object)this$photoSize).equals(other$photoSize)) {
            return false;
        }
        Integer this$photoWidth = this.getPhotoWidth();
        Integer other$photoWidth = other.getPhotoWidth();
        if (this$photoWidth == null ? other$photoWidth != null : !((Object)this$photoWidth).equals(other$photoWidth)) {
            return false;
        }
        Integer this$photoHeight = this.getPhotoHeight();
        Integer other$photoHeight = other.getPhotoHeight();
        if (this$photoHeight == null ? other$photoHeight != null : !((Object)this$photoHeight).equals(other$photoHeight)) {
            return false;
        }
        Boolean this$needName = this.getNeedName();
        Boolean other$needName = other.getNeedName();
        if (this$needName == null ? other$needName != null : !((Object)this$needName).equals(other$needName)) {
            return false;
        }
        Boolean this$needPhoneNumber = this.getNeedPhoneNumber();
        Boolean other$needPhoneNumber = other.getNeedPhoneNumber();
        if (this$needPhoneNumber == null ? other$needPhoneNumber != null : !((Object)this$needPhoneNumber).equals(other$needPhoneNumber)) {
            return false;
        }
        Boolean this$needEmail = this.getNeedEmail();
        Boolean other$needEmail = other.getNeedEmail();
        if (this$needEmail == null ? other$needEmail != null : !((Object)this$needEmail).equals(other$needEmail)) {
            return false;
        }
        Boolean this$needShippingAddress = this.getNeedShippingAddress();
        Boolean other$needShippingAddress = other.getNeedShippingAddress();
        if (this$needShippingAddress == null ? other$needShippingAddress != null : !((Object)this$needShippingAddress).equals(other$needShippingAddress)) {
            return false;
        }
        Boolean this$isFlexible = this.getIsFlexible();
        Boolean other$isFlexible = other.getIsFlexible();
        if (this$isFlexible == null ? other$isFlexible != null : !((Object)this$isFlexible).equals(other$isFlexible)) {
            return false;
        }
        Boolean this$sendPhoneNumberToProvider = this.getSendPhoneNumberToProvider();
        Boolean other$sendPhoneNumberToProvider = other.getSendPhoneNumberToProvider();
        if (this$sendPhoneNumberToProvider == null ? other$sendPhoneNumberToProvider != null : !((Object)this$sendPhoneNumberToProvider).equals(other$sendPhoneNumberToProvider)) {
            return false;
        }
        Boolean this$sendEmailToProvider = this.getSendEmailToProvider();
        Boolean other$sendEmailToProvider = other.getSendEmailToProvider();
        if (this$sendEmailToProvider == null ? other$sendEmailToProvider != null : !((Object)this$sendEmailToProvider).equals(other$sendEmailToProvider)) {
            return false;
        }
        Integer this$maxTipAmount = this.getMaxTipAmount();
        Integer other$maxTipAmount = other.getMaxTipAmount();
        if (this$maxTipAmount == null ? other$maxTipAmount != null : !((Object)this$maxTipAmount).equals(other$maxTipAmount)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$providerToken = this.getProviderToken();
        String other$providerToken = other.getProviderToken();
        if (this$providerToken == null ? other$providerToken != null : !this$providerToken.equals(other$providerToken)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<LabeledPrice> this$prices = this.getPrices();
        List<LabeledPrice> other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        String this$photoUrl = this.getPhotoUrl();
        String other$photoUrl = other.getPhotoUrl();
        if (this$photoUrl == null ? other$photoUrl != null : !this$photoUrl.equals(other$photoUrl)) {
            return false;
        }
        String this$providerData = this.getProviderData();
        String other$providerData = other.getProviderData();
        if (this$providerData == null ? other$providerData != null : !this$providerData.equals(other$providerData)) {
            return false;
        }
        List<Integer> this$suggestedTipAmounts = this.getSuggestedTipAmounts();
        List<Integer> other$suggestedTipAmounts = other.getSuggestedTipAmounts();
        return !(this$suggestedTipAmounts == null ? other$suggestedTipAmounts != null : !((Object)this$suggestedTipAmounts).equals(other$suggestedTipAmounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateInvoiceLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $photoSize = this.getPhotoSize();
        result = result * 59 + ($photoSize == null ? 43 : ((Object)$photoSize).hashCode());
        Integer $photoWidth = this.getPhotoWidth();
        result = result * 59 + ($photoWidth == null ? 43 : ((Object)$photoWidth).hashCode());
        Integer $photoHeight = this.getPhotoHeight();
        result = result * 59 + ($photoHeight == null ? 43 : ((Object)$photoHeight).hashCode());
        Boolean $needName = this.getNeedName();
        result = result * 59 + ($needName == null ? 43 : ((Object)$needName).hashCode());
        Boolean $needPhoneNumber = this.getNeedPhoneNumber();
        result = result * 59 + ($needPhoneNumber == null ? 43 : ((Object)$needPhoneNumber).hashCode());
        Boolean $needEmail = this.getNeedEmail();
        result = result * 59 + ($needEmail == null ? 43 : ((Object)$needEmail).hashCode());
        Boolean $needShippingAddress = this.getNeedShippingAddress();
        result = result * 59 + ($needShippingAddress == null ? 43 : ((Object)$needShippingAddress).hashCode());
        Boolean $isFlexible = this.getIsFlexible();
        result = result * 59 + ($isFlexible == null ? 43 : ((Object)$isFlexible).hashCode());
        Boolean $sendPhoneNumberToProvider = this.getSendPhoneNumberToProvider();
        result = result * 59 + ($sendPhoneNumberToProvider == null ? 43 : ((Object)$sendPhoneNumberToProvider).hashCode());
        Boolean $sendEmailToProvider = this.getSendEmailToProvider();
        result = result * 59 + ($sendEmailToProvider == null ? 43 : ((Object)$sendEmailToProvider).hashCode());
        Integer $maxTipAmount = this.getMaxTipAmount();
        result = result * 59 + ($maxTipAmount == null ? 43 : ((Object)$maxTipAmount).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $providerToken = this.getProviderToken();
        result = result * 59 + ($providerToken == null ? 43 : $providerToken.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<LabeledPrice> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        String $photoUrl = this.getPhotoUrl();
        result = result * 59 + ($photoUrl == null ? 43 : $photoUrl.hashCode());
        String $providerData = this.getProviderData();
        result = result * 59 + ($providerData == null ? 43 : $providerData.hashCode());
        List<Integer> $suggestedTipAmounts = this.getSuggestedTipAmounts();
        result = result * 59 + ($suggestedTipAmounts == null ? 43 : ((Object)$suggestedTipAmounts).hashCode());
        return result;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getPayload() {
        return this.payload;
    }

    @NonNull
    public String getProviderToken() {
        return this.providerToken;
    }

    @NonNull
    public String getCurrency() {
        return this.currency;
    }

    @NonNull
    public List<LabeledPrice> getPrices() {
        return this.prices;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public Integer getPhotoSize() {
        return this.photoSize;
    }

    public Integer getPhotoWidth() {
        return this.photoWidth;
    }

    public Integer getPhotoHeight() {
        return this.photoHeight;
    }

    public Boolean getNeedName() {
        return this.needName;
    }

    public Boolean getNeedPhoneNumber() {
        return this.needPhoneNumber;
    }

    public Boolean getNeedEmail() {
        return this.needEmail;
    }

    public Boolean getNeedShippingAddress() {
        return this.needShippingAddress;
    }

    public Boolean getIsFlexible() {
        return this.isFlexible;
    }

    public Boolean getSendPhoneNumberToProvider() {
        return this.sendPhoneNumberToProvider;
    }

    public Boolean getSendEmailToProvider() {
        return this.sendEmailToProvider;
    }

    public String getProviderData() {
        return this.providerData;
    }

    public Integer getMaxTipAmount() {
        return this.maxTipAmount;
    }

    public List<Integer> getSuggestedTipAmounts() {
        return this.suggestedTipAmounts;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="description")
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @JsonProperty(value="payload")
    public void setPayload(@NonNull String payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.payload = payload;
    }

    @JsonProperty(value="provider_token")
    public void setProviderToken(@NonNull String providerToken) {
        if (providerToken == null) {
            throw new NullPointerException("providerToken is marked non-null but is null");
        }
        this.providerToken = providerToken;
    }

    @JsonProperty(value="currency")
    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.currency = currency;
    }

    @JsonProperty(value="prices")
    public void setPrices(@NonNull List<LabeledPrice> prices) {
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.prices = prices;
    }

    @JsonProperty(value="photo_url")
    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    @JsonProperty(value="photo_size")
    public void setPhotoSize(Integer photoSize) {
        this.photoSize = photoSize;
    }

    @JsonProperty(value="photo_width")
    public void setPhotoWidth(Integer photoWidth) {
        this.photoWidth = photoWidth;
    }

    @JsonProperty(value="photo_height")
    public void setPhotoHeight(Integer photoHeight) {
        this.photoHeight = photoHeight;
    }

    @JsonProperty(value="need_name")
    public void setNeedName(Boolean needName) {
        this.needName = needName;
    }

    @JsonProperty(value="need_phone_number")
    public void setNeedPhoneNumber(Boolean needPhoneNumber) {
        this.needPhoneNumber = needPhoneNumber;
    }

    @JsonProperty(value="need_email")
    public void setNeedEmail(Boolean needEmail) {
        this.needEmail = needEmail;
    }

    @JsonProperty(value="need_shipping_address")
    public void setNeedShippingAddress(Boolean needShippingAddress) {
        this.needShippingAddress = needShippingAddress;
    }

    @JsonProperty(value="is_flexible")
    public void setIsFlexible(Boolean isFlexible) {
        this.isFlexible = isFlexible;
    }

    @JsonProperty(value="send_phone_number_to_provider")
    public void setSendPhoneNumberToProvider(Boolean sendPhoneNumberToProvider) {
        this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
    }

    @JsonProperty(value="send_email_to_provider")
    public void setSendEmailToProvider(Boolean sendEmailToProvider) {
        this.sendEmailToProvider = sendEmailToProvider;
    }

    @JsonProperty(value="provider_data")
    public void setProviderData(String providerData) {
        this.providerData = providerData;
    }

    @JsonProperty(value="max_tip_amount")
    public void setMaxTipAmount(Integer maxTipAmount) {
        this.maxTipAmount = maxTipAmount;
    }

    @JsonProperty(value="suggested_tip_amounts")
    public void setSuggestedTipAmounts(List<Integer> suggestedTipAmounts) {
        this.suggestedTipAmounts = suggestedTipAmounts;
    }

    public String toString() {
        return "CreateInvoiceLink(title=" + this.getTitle() + ", description=" + this.getDescription() + ", payload=" + this.getPayload() + ", providerToken=" + this.getProviderToken() + ", currency=" + this.getCurrency() + ", prices=" + this.getPrices() + ", photoUrl=" + this.getPhotoUrl() + ", photoSize=" + this.getPhotoSize() + ", photoWidth=" + this.getPhotoWidth() + ", photoHeight=" + this.getPhotoHeight() + ", needName=" + this.getNeedName() + ", needPhoneNumber=" + this.getNeedPhoneNumber() + ", needEmail=" + this.getNeedEmail() + ", needShippingAddress=" + this.getNeedShippingAddress() + ", isFlexible=" + this.getIsFlexible() + ", sendPhoneNumberToProvider=" + this.getSendPhoneNumberToProvider() + ", sendEmailToProvider=" + this.getSendEmailToProvider() + ", providerData=" + this.getProviderData() + ", maxTipAmount=" + this.getMaxTipAmount() + ", suggestedTipAmounts=" + this.getSuggestedTipAmounts() + ")";
    }

    public CreateInvoiceLink(@NonNull String title, @NonNull String description, @NonNull String payload, @NonNull String providerToken, @NonNull String currency, @NonNull List<LabeledPrice> prices) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (providerToken == null) {
            throw new NullPointerException("providerToken is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.title = title;
        this.description = description;
        this.payload = payload;
        this.providerToken = providerToken;
        this.currency = currency;
        this.prices = prices;
    }

    public CreateInvoiceLink() {
    }

    public CreateInvoiceLink(@NonNull String title, @NonNull String description, @NonNull String payload, @NonNull String providerToken, @NonNull String currency, @NonNull List<LabeledPrice> prices, String photoUrl, Integer photoSize, Integer photoWidth, Integer photoHeight, Boolean needName, Boolean needPhoneNumber, Boolean needEmail, Boolean needShippingAddress, Boolean isFlexible, Boolean sendPhoneNumberToProvider, Boolean sendEmailToProvider, String providerData, Integer maxTipAmount, List<Integer> suggestedTipAmounts) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (providerToken == null) {
            throw new NullPointerException("providerToken is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.title = title;
        this.description = description;
        this.payload = payload;
        this.providerToken = providerToken;
        this.currency = currency;
        this.prices = prices;
        this.photoUrl = photoUrl;
        this.photoSize = photoSize;
        this.photoWidth = photoWidth;
        this.photoHeight = photoHeight;
        this.needName = needName;
        this.needPhoneNumber = needPhoneNumber;
        this.needEmail = needEmail;
        this.needShippingAddress = needShippingAddress;
        this.isFlexible = isFlexible;
        this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
        this.sendEmailToProvider = sendEmailToProvider;
        this.providerData = providerData;
        this.maxTipAmount = maxTipAmount;
        this.suggestedTipAmounts = suggestedTipAmounts;
    }

    public static class CreateInvoiceLinkBuilder {
        private String title;
        private String description;
        private String payload;
        private String providerToken;
        private String currency;
        private ArrayList<LabeledPrice> prices;
        private String photoUrl;
        private Integer photoSize;
        private Integer photoWidth;
        private Integer photoHeight;
        private Boolean needName;
        private Boolean needPhoneNumber;
        private Boolean needEmail;
        private Boolean needShippingAddress;
        private Boolean isFlexible;
        private Boolean sendPhoneNumberToProvider;
        private Boolean sendEmailToProvider;
        private String providerData;
        private Integer maxTipAmount;
        private ArrayList<Integer> suggestedTipAmounts;

        CreateInvoiceLinkBuilder() {
        }

        @JsonProperty(value="title")
        public CreateInvoiceLinkBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        public CreateInvoiceLinkBuilder description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        @JsonProperty(value="payload")
        public CreateInvoiceLinkBuilder payload(@NonNull String payload) {
            if (payload == null) {
                throw new NullPointerException("payload is marked non-null but is null");
            }
            this.payload = payload;
            return this;
        }

        @JsonProperty(value="provider_token")
        public CreateInvoiceLinkBuilder providerToken(@NonNull String providerToken) {
            if (providerToken == null) {
                throw new NullPointerException("providerToken is marked non-null but is null");
            }
            this.providerToken = providerToken;
            return this;
        }

        @JsonProperty(value="currency")
        public CreateInvoiceLinkBuilder currency(@NonNull String currency) {
            if (currency == null) {
                throw new NullPointerException("currency is marked non-null but is null");
            }
            this.currency = currency;
            return this;
        }

        public CreateInvoiceLinkBuilder price(LabeledPrice price) {
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.add(price);
            return this;
        }

        @JsonProperty(value="prices")
        public CreateInvoiceLinkBuilder prices(Collection<? extends LabeledPrice> prices) {
            if (prices == null) {
                throw new NullPointerException("prices cannot be null");
            }
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.addAll(prices);
            return this;
        }

        public CreateInvoiceLinkBuilder clearPrices() {
            if (this.prices != null) {
                this.prices.clear();
            }
            return this;
        }

        @JsonProperty(value="photo_url")
        public CreateInvoiceLinkBuilder photoUrl(String photoUrl) {
            this.photoUrl = photoUrl;
            return this;
        }

        @JsonProperty(value="photo_size")
        public CreateInvoiceLinkBuilder photoSize(Integer photoSize) {
            this.photoSize = photoSize;
            return this;
        }

        @JsonProperty(value="photo_width")
        public CreateInvoiceLinkBuilder photoWidth(Integer photoWidth) {
            this.photoWidth = photoWidth;
            return this;
        }

        @JsonProperty(value="photo_height")
        public CreateInvoiceLinkBuilder photoHeight(Integer photoHeight) {
            this.photoHeight = photoHeight;
            return this;
        }

        @JsonProperty(value="need_name")
        public CreateInvoiceLinkBuilder needName(Boolean needName) {
            this.needName = needName;
            return this;
        }

        @JsonProperty(value="need_phone_number")
        public CreateInvoiceLinkBuilder needPhoneNumber(Boolean needPhoneNumber) {
            this.needPhoneNumber = needPhoneNumber;
            return this;
        }

        @JsonProperty(value="need_email")
        public CreateInvoiceLinkBuilder needEmail(Boolean needEmail) {
            this.needEmail = needEmail;
            return this;
        }

        @JsonProperty(value="need_shipping_address")
        public CreateInvoiceLinkBuilder needShippingAddress(Boolean needShippingAddress) {
            this.needShippingAddress = needShippingAddress;
            return this;
        }

        @JsonProperty(value="is_flexible")
        public CreateInvoiceLinkBuilder isFlexible(Boolean isFlexible) {
            this.isFlexible = isFlexible;
            return this;
        }

        @JsonProperty(value="send_phone_number_to_provider")
        public CreateInvoiceLinkBuilder sendPhoneNumberToProvider(Boolean sendPhoneNumberToProvider) {
            this.sendPhoneNumberToProvider = sendPhoneNumberToProvider;
            return this;
        }

        @JsonProperty(value="send_email_to_provider")
        public CreateInvoiceLinkBuilder sendEmailToProvider(Boolean sendEmailToProvider) {
            this.sendEmailToProvider = sendEmailToProvider;
            return this;
        }

        @JsonProperty(value="provider_data")
        public CreateInvoiceLinkBuilder providerData(String providerData) {
            this.providerData = providerData;
            return this;
        }

        @JsonProperty(value="max_tip_amount")
        public CreateInvoiceLinkBuilder maxTipAmount(Integer maxTipAmount) {
            this.maxTipAmount = maxTipAmount;
            return this;
        }

        public CreateInvoiceLinkBuilder suggestedTipAmount(Integer suggestedTipAmount) {
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList();
            }
            this.suggestedTipAmounts.add(suggestedTipAmount);
            return this;
        }

        @JsonProperty(value="suggested_tip_amounts")
        public CreateInvoiceLinkBuilder suggestedTipAmounts(Collection<? extends Integer> suggestedTipAmounts) {
            if (suggestedTipAmounts == null) {
                throw new NullPointerException("suggestedTipAmounts cannot be null");
            }
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList();
            }
            this.suggestedTipAmounts.addAll(suggestedTipAmounts);
            return this;
        }

        public CreateInvoiceLinkBuilder clearSuggestedTipAmounts() {
            if (this.suggestedTipAmounts != null) {
                this.suggestedTipAmounts.clear();
            }
            return this;
        }

        public CreateInvoiceLink build() {
            List<Integer> suggestedTipAmounts;
            List<LabeledPrice> prices;
            switch (this.prices == null ? 0 : this.prices.size()) {
                case 0: {
                    prices = Collections.emptyList();
                    break;
                }
                case 1: {
                    prices = Collections.singletonList(this.prices.get(0));
                    break;
                }
                default: {
                    prices = Collections.unmodifiableList(new ArrayList<LabeledPrice>(this.prices));
                }
            }
            switch (this.suggestedTipAmounts == null ? 0 : this.suggestedTipAmounts.size()) {
                case 0: {
                    suggestedTipAmounts = Collections.emptyList();
                    break;
                }
                case 1: {
                    suggestedTipAmounts = Collections.singletonList(this.suggestedTipAmounts.get(0));
                    break;
                }
                default: {
                    suggestedTipAmounts = Collections.unmodifiableList(new ArrayList<Integer>(this.suggestedTipAmounts));
                }
            }
            return new CreateInvoiceLink(this.title, this.description, this.payload, this.providerToken, this.currency, prices, this.photoUrl, this.photoSize, this.photoWidth, this.photoHeight, this.needName, this.needPhoneNumber, this.needEmail, this.needShippingAddress, this.isFlexible, this.sendPhoneNumberToProvider, this.sendEmailToProvider, this.providerData, this.maxTipAmount, suggestedTipAmounts);
        }

        public String toString() {
            return "CreateInvoiceLink.CreateInvoiceLinkBuilder(title=" + this.title + ", description=" + this.description + ", payload=" + this.payload + ", providerToken=" + this.providerToken + ", currency=" + this.currency + ", prices=" + this.prices + ", photoUrl=" + this.photoUrl + ", photoSize=" + this.photoSize + ", photoWidth=" + this.photoWidth + ", photoHeight=" + this.photoHeight + ", needName=" + this.needName + ", needPhoneNumber=" + this.needPhoneNumber + ", needEmail=" + this.needEmail + ", needShippingAddress=" + this.needShippingAddress + ", isFlexible=" + this.isFlexible + ", sendPhoneNumberToProvider=" + this.sendPhoneNumberToProvider + ", sendEmailToProvider=" + this.sendEmailToProvider + ", providerData=" + this.providerData + ", maxTipAmount=" + this.maxTipAmount + ", suggestedTipAmounts=" + this.suggestedTipAmounts + ")";
        }
    }
}

