/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.struts.action;

import java.util.Date;
import org.apache.struts.action.ActionForward;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractObjectDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.NPayDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.npay.NPayService;
import ru.bgcrm.plugin.bgbilling.struts.action.BaseAction;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/proto/npay")
public class NPayAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/bgbilling/npay";

    public ActionForward serviceList(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        form.setResponseData("list", new NPayDAO(form.getUser(), billingId, moduleId).getServiceList(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/npay/service_list.jsp");
    }

    public ActionForward serviceGet(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        NPayService service = null;
        if (form.getId() > 0) {
            service = new NPayDAO(form.getUser(), billingId, moduleId).getService(form.getId());
        } else {
            service = new NPayService();
            service.setDateFrom(new Date());
        }
        form.setResponseData("service", service);
        form.setResponseData("serviceTypeList", new DirectoryDAO(form.getUser(), billingId).getServiceTypeList(moduleId));
        form.setResponseData("objectList", new ContractObjectDAO(form.getUser(), billingId).getContractObjects(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/npay/service_editor.jsp");
    }

    public ActionForward serviceUpdate(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        NPayService service = new NPayService();
        service.setId(form.getId());
        service.setContractId(contractId);
        service.setServiceId(form.getParamInt("serviceId"));
        service.setDateFrom(form.getParamDate("dateFrom"));
        service.setDateTo(form.getParamDate("dateTo"));
        service.setObjectId(form.getParamInt("objectId"));
        service.setComment(form.getParam("comment", ""));
        new NPayDAO(form.getUser(), billingId, moduleId).updateService(service);
        return this.json(conSet, form);
    }

    public ActionForward serviceDelete(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int moduleId = form.getParamInt("moduleId");
        new NPayDAO(form.getUser(), billingId, moduleId).deleteService(form.getParamInt("contractId"), form.getId());
        return this.json(conSet, form);
    }
}

