/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.util.Utils;

public class ContractType
extends IdTitle {
    private final String billingId;
    private final int patternId;
    private final List<IdTitle> tariffList;
    private final Map<Integer, String> tariffMap = new HashMap<Integer, String>();
    private final int tariffPosition;

    public ContractType(int id, ConfigMap param) {
        super(id, param.get("title"));
        this.billingId = param.get("billing");
        this.patternId = param.getInt("patternId", 0);
        this.tariffList = Utils.parseIdTitleList(param.get("tariffList", ""));
        this.tariffPosition = param.getInt("tariffPosition", -1);
        for (IdTitle it : this.tariffList) {
            this.tariffMap.put(it.getId(), it.getTitle());
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getBillingId() {
        return this.billingId;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public List<IdTitle> getTariffList() {
        return this.tariffList;
    }

    public Map<Integer, String> getTariffMap() {
        return this.tariffMap;
    }

    public int getTariffPosition() {
        return this.tariffPosition;
    }
}

