/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.dao.message.process.MessagePossibleProcessSearch;
import org.bgerp.model.process.link.ProcessLink;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamAddressValue;
import ru.bgcrm.util.Utils;

@Bean
public class BGBillingMessagePossibleProcessSearchFoundLinksContractAddressCity
extends MessagePossibleProcessSearch {
    private final Map<String, Integer> contractAddressParamIds;
    private final int processCityParamId;

    public BGBillingMessagePossibleProcessSearchFoundLinksContractAddressCity(int id, ConfigMap configMap) {
        super(id, configMap);
        this.contractAddressParamIds = this.loadContractAddressParamId(configMap);
        this.processCityParamId = configMap.getInt("processCityParamId");
        if (this.contractAddressParamIds.isEmpty()) {
            throw new IllegalArgumentException("'contractAddressParamId' is not specified");
        }
        if (this.processCityParamId <= 0) {
            throw new IllegalArgumentException("'processCityParamId' must be positive int");
        }
    }

    private Map<String, Integer> loadContractAddressParamId(ConfigMap configMap) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String key = "contractAddressParamId";
        int addressParamId = configMap.getInt("contractAddressParamId");
        if (addressParamId > 0) {
            result.put("", addressParamId);
        }
        for (Map.Entry<String, String> me : configMap.sub("contractAddressParamId.").entrySet()) {
            result.put(me.getKey(), Utils.parseInt(me.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean addQuery(User user, PreparedQuery pq, boolean first, String from, List<ProcessLink> links, Boolean open) {
        TreeSet<Integer> cityIds = new TreeSet<Integer>();
        for (CommonObjectLink commonObjectLink : links) {
            if (!commonObjectLink.getLinkObjectType().startsWith("contract")) continue;
            this.log.debug("linkObjectType: {}, linkObjectId: {}", commonObjectLink.getLinkObjectType(), commonObjectLink.getLinkObjectId());
            String billingId = new Contract(commonObjectLink).getBillingId();
            Integer paramId = this.contractAddressParamIds.getOrDefault(billingId, this.contractAddressParamIds.get(""));
            if (paramId == null) {
                this.log.error("Not found 'contractAddressParamId' for billing ID: {}", billingId);
                continue;
            }
            ParamAddressValue addr = new ContractParamDAO(user, billingId).getAddressParam(commonObjectLink.getLinkObjectId(), paramId);
            if (addr == null) continue;
            cityIds.add(addr.getCityId());
        }
        if (cityIds.isEmpty()) {
            return false;
        }
        if (!first) {
            pq.addQuery(" UNION ALL ");
        }
        pq.addQuery("SELECT p.*, ? AS type FROM  process AS p");
        pq.addInt(this.getId());
        pq.addQuery(" INNER JOIN  param_list AS pcity ON p.id=pcity.id AND pcity.param_id=? AND pcity.value IN (" + Utils.toString(cityIds) + ")");
        pq.addInt(this.processCityParamId);
        this.addOpenFilter(pq, open);
        return true;
    }
}

