/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model.work;

import java.util.Calendar;
import java.util.Date;
import org.bgerp.plugin.pln.callboard.model.work.CellRange;
import org.bgerp.plugin.pln.callboard.model.work.ShiftData;
import org.bgerp.util.Dynamic;
import ru.bgcrm.util.TimeUtils;

public class FreeSlotRange {
    private final Date date;
    public final int groupId;
    public final ShiftData shiftData;
    private final CellRange cellRange;
    public final int slotFrom;
    public final int duration;
    private final int dayMinuteFrom;

    public FreeSlotRange(Date date, int groupId, ShiftData shiftData, CellRange cellRange, int slotFrom, int duration) {
        this.date = date;
        this.groupId = groupId;
        this.shiftData = shiftData;
        this.cellRange = cellRange;
        this.slotFrom = slotFrom;
        this.duration = duration;
        this.dayMinuteFrom = this.getDayMinuteFrom();
    }

    private int getDayMinuteFrom() {
        int result = this.cellRange.workTypeTime.getDayMinuteFrom();
        if (this.cellRange.workType.getTimeSetMode() == 1) {
            result += this.slotFrom * this.cellRange.workType.getTimeSetStep();
        }
        return result;
    }

    @Dynamic
    public Date getTime() {
        Calendar cal = TimeUtils.convertDateToCalendar(this.date);
        cal.add(12, this.dayMinuteFrom);
        return TimeUtils.convertCalendarToDate(cal);
    }

    @Dynamic
    public int getGroupId() {
        return this.groupId;
    }

    @Dynamic
    public ShiftData getShiftData() {
        return this.shiftData;
    }
}

