/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import org.bgerp.model.Pageable;
import org.bgerp.plugin.bil.invoice.dao.InvoiceDAO;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;

public class InvoiceSearchDAO
extends CommonDAO {
    private int processId;
    private Boolean paid;
    private boolean orderDefault;

    public InvoiceSearchDAO(Connection con) {
        super(con);
    }

    public InvoiceSearchDAO withProcessId(int value) {
        this.processId = value;
        return this;
    }

    public InvoiceSearchDAO withPaid(boolean value) {
        this.paid = value;
        return this;
    }

    public InvoiceSearchDAO orderDefault() {
        this.orderDefault = true;
        return this;
    }

    public void search(Pageable<Invoice> result) throws Exception {
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM  invoice  WHERE 1>0";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            if (this.processId > 0) {
                pq.addQuery(" AND ").addQuery("process_id=?").addInt(this.processId);
            }
            if (this.paid != null) {
                pq.addQuery(" AND ").addQuery("payment_date IS ").addQuery(this.paid != false ? "NOT" : "").addQuery("NULL");
            }
            if (this.orderDefault) {
                pq.addQuery(" ORDER BY ").addQuery("date_from").addQuery(" DESC ").addQuery(", id").addQuery(" DESC ");
            }
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.getList().add(InvoiceDAO.getFromRs(rs));
            }
            result.getPage().setRecordCount(pq.getPrepared());
        }
    }
}

