/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.expression;

import java.sql.Connection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.expression.ExpressionContextAccessingObject;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.plugin.msg.email.ExpressionObject;
import org.bgerp.util.Log;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.action.ProcessAction;
import ru.bgcrm.struts.form.DynActionForm;

public class ProcessChangeExpressionObject
extends ExpressionContextAccessingObject {
    private static final Log log = Log.getLog();
    private final Process process;
    private final DynActionForm form;
    private final Connection con;

    public ProcessChangeExpressionObject(Process process, DynActionForm form, Connection con) {
        this.process = process;
        this.form = form;
        this.con = con;
    }

    @Override
    public void toContext(Map<String, Object> context) {
        super.toContext(context);
        context.put(null, this);
    }

    public void delete() throws Exception {
        ProcessAction.processDelete(this.form, this.con, this.process);
    }

    public void addGroups(Set<Integer> groupIds, int roleId) throws Exception {
        ProcessType type = ProcessAction.getProcessType(this.process.getTypeId());
        HashSet<ProcessGroup> processGroups = new HashSet<ProcessGroup>(this.process.getGroups());
        AbstractSet addingProcessGroups = ProcessGroup.toProcessGroupSet(groupIds, roleId);
        if (type.getProperties().getAllowedGroups().size() > 0) {
            addingProcessGroups = new HashSet(CollectionUtils.intersection((Iterable)addingProcessGroups, (Iterable)type.getProperties().getAllowedGroups()));
        }
        if (processGroups.addAll(addingProcessGroups)) {
            ProcessAction.processGroupsUpdate(this.form, this.con, this.process, processGroups);
        }
    }

    public void deleteGroups(Set<Integer> ids) throws Exception {
        Set<ProcessGroup> processGroups = this.process.getGroups().stream().filter(pg -> !ids.contains(pg.getGroupId())).collect(Collectors.toSet());
        ProcessAction.processGroupsUpdate(this.form, this.con, this.process, processGroups);
        Set<ProcessExecutor> executors = this.process.getExecutors().stream().filter(pe -> !ids.contains(pe.getGroupId())).collect(Collectors.toSet());
        ProcessAction.processExecutorsUpdate(this.form, this.con, this.process, processGroups, executors);
    }

    public void addExecutors(Set<Integer> ids) throws Exception {
        ProcessGroup processGroup = null;
        for (ProcessGroup pg : this.process.getGroups()) {
            for (Integer executorId : ids) {
                User user = UserCache.getUser(executorId);
                if (!user.getGroupIds().contains(pg.getGroupId())) continue;
                if (processGroup != null && processGroup.getGroupId() != pg.getGroupId()) {
                    throw new BGMessageException("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0438 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u043a \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u043c \u0433\u0440\u0443\u043f\u043f\u0430\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430.", new Object[0]);
                }
                processGroup = pg;
            }
        }
        if (processGroup == null) {
            throw new BGMessageException("The set executors '{}' are not members of process execution groups '{}'.", ids, this.process.getGroupIds());
        }
        Set<ProcessExecutor> executors = ProcessExecutor.getProcessExecutors(this.process.getExecutors(), Collections.singleton(processGroup));
        executors.addAll(ProcessExecutor.toProcessExecutorSet(ids, processGroup));
        ProcessAction.processExecutorsUpdate(this.form, this.con, this.process, Collections.singleton(processGroup), executors);
    }

    public void addExecutors(Set<Integer> groupIds, Set<Integer> userIds, int roleId) throws Exception {
        Set<ProcessGroup> processGroups = this.process.getGroups().stream().filter(pg -> !(roleId >= 0 && pg.getRoleId() != roleId || groupIds != null && !groupIds.contains(pg.getGroupId()))).collect(Collectors.toSet());
        if (processGroups.isEmpty()) {
            throw new BGMessageException("No matching execution groups found; groupIds: {}, roleId: {}", groupIds, roleId);
        }
        Set<ProcessExecutor> executors = ProcessExecutor.getProcessExecutors(this.process.getExecutors(), processGroups);
        for (ProcessGroup processGroup : processGroups) {
            executors.addAll(ProcessExecutor.toProcessExecutorSet(userIds, processGroup));
        }
        ProcessAction.processExecutorsUpdate(this.form, this.con, this.process, processGroups, executors);
    }

    public void deleteExecutors(Set<Integer> ids) throws Exception {
        ProcessGroups processGroups = this.process.getGroups();
        Set<ProcessExecutor> executors = this.process.getExecutors().stream().filter(pe -> !ids.contains(pe.getUserId())).collect(Collectors.toSet());
        ProcessAction.processExecutorsUpdate(this.form, this.con, this.process, processGroups, executors);
    }

    public void setPriority(int value) throws Exception {
        this.process.setPriority(value);
        new ProcessDAO(this.con).updateProcess(this.process);
    }

    public void setStatus(int value, String comment) throws Exception {
        StatusChange change = new StatusChange();
        change.setDate(new Date());
        change.setProcessId(this.process.getId());
        change.setUserId(this.form.getUserId());
        change.setStatusId(value);
        change.setComment(comment);
        ProcessAction.processStatusUpdate(this.form, this.con, this.process, change);
        new ProcessDAO(this.con).updateProcess(this.process);
    }

    @Deprecated
    public void emailNotifyExecutors(int paramId, String subject, String text) throws Exception {
        log.warnd("Used deprecated call 'emailNotifyExecutors', use 'email.sendMessageToExecutors' instead.", new Object[0]);
        ExpressionObject eo = new ExpressionObject();
        eo.toContext(this.context);
        eo.sendMessageToExecutors(paramId, subject, text);
    }

    @Deprecated
    public void emailNotifyUsers(Collection<Integer> userIds, int paramId, String subject, String text) throws Exception {
        log.warnd("Used deprecated call 'emailNotifyUsers', use 'email.sendMessageToUsers' instead.", new Object[0]);
        ExpressionObject eo = new ExpressionObject();
        eo.toContext(this.context);
        eo.sendMessageToUsers(userIds, paramId, subject, text);
    }
}

