/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.customer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.util.Utils;

public class CustomerParamSearchDAO
extends CommonDAO {
    private Set<Integer> paramTextIds;
    private String paramTextValue;

    public CustomerParamSearchDAO(Connection con) {
        super(con);
    }

    public CustomerParamSearchDAO withParamTextIds(Set<Integer> values) {
        this.paramTextIds = values;
        return this;
    }

    public CustomerParamSearchDAO withParamTextValue(String value) {
        this.paramTextValue = value;
        return this;
    }

    public void search(Pageable<ParameterSearchedObject<Customer>> result) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            List<ParameterSearchedObject<Customer>> list = result.getList();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS c.*, param.* FROM  customer AS c");
            if (!Utils.notBlankString(this.paramTextValue)) {
                throw new IllegalArgumentException("No param value filter was defined.");
            }
            pq.addQuery(" INNER JOIN  param_text AS param ON c.id=param.id AND param.value LIKE ?");
            pq.addString(this.paramTextValue);
            pq.addQuery(" INNER JOIN  param_pref AS param_pref ON param.param_id=param_pref.id AND param_pref.object=?");
            pq.addString("customer");
            if (CollectionUtils.isNotEmpty(this.paramTextIds)) {
                pq.addQuery(" AND param.param_id IN (").addQuery(Utils.toString(this.paramTextIds)).addQuery(")");
            }
            pq.addQuery(" WHERE 1>0 ");
            pq.addQuery(" ORDER BY c.title");
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(new ParameterSearchedObject<Customer>(CustomerDAO.getCustomerFromRs(rs, "c."), rs.getInt("param.param_id"), rs.getString("param.value")));
            }
            page.setRecordCount(pq.getPrepared());
        }
    }
}

