/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateText;
import net.sf.jasperreports.engine.fill.PrintElementOriginator;
import net.sf.jasperreports.engine.fill.TextFormat;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class JRTemplatePrintText
extends JRTemplatePrintElement
implements JRPrintText {
    private static final long serialVersionUID = 10200L;
    private static final int SERIALIZATION_FLAG_ANCHOR = 1;
    private static final int SERIALIZATION_FLAG_HYPERLINK = 2;
    private static final int SERIALIZATION_FLAG_RTL = 4;
    private static final int SERIALIZATION_FLAG_TRUNCATION = 8;
    private static final int SERIALIZATION_FLAG_LINE_BREAK_OFFSETS = 16;
    private static final int SERIALIZATION_FLAG_ZERO_LINE_BREAK_OFFSETS = 32;
    private static final int SERIALIZATION_FLAG_HAS_VALUE = 64;
    private static final int SERIALIZATION_FLAG_HYPERLINK_OMITTED = 128;
    private String text;
    private Integer textTruncateIndex;
    private String textTruncateSuffix;
    private short[] lineBreakOffsets;
    private Object value;
    private float lineSpacingFactor;
    private float leadingOffset;
    private RunDirectionEnum runDirectionValue;
    private Float averageCharWidth;
    private float textHeight;
    private TextFormat textFormat;
    private String anchorName;
    private boolean hyperlinkOmitted;
    private String hyperlinkReference;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 62100;
    private byte runDirection;

    public JRTemplatePrintText() {
    }

    public JRTemplatePrintText(JRTemplateText text, PrintElementOriginator originator) {
        super(text, originator);
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Integer getTextTruncateIndex() {
        return this.textTruncateIndex;
    }

    @Override
    public void setTextTruncateIndex(Integer textTruncateIndex) {
        this.textTruncateIndex = textTruncateIndex;
    }

    @Override
    public String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    @Override
    public void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
    }

    @Override
    public short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    @Override
    public void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    @Override
    public String getFullText() {
        String fullText = this.text;
        if (this.textTruncateIndex == null && this.textTruncateSuffix != null) {
            fullText = (fullText == null ? "" : fullText) + this.textTruncateSuffix;
        }
        return fullText;
    }

    @Override
    public String getOriginalText() {
        return this.text;
    }

    @Override
    public JRStyledText getFullStyledText(JRStyledTextAttributeSelector attributeSelector) {
        if (this.getFullText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(this), this.getFullText(), !"none".equals(this.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(this));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    @Override
    public void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    @Override
    public float getLeadingOffset() {
        return this.leadingOffset;
    }

    @Override
    public void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    @Override
    public HorizontalTextAlignEnum getHorizontalTextAlign() {
        return ((JRTemplateText)this.template).getHorizontalTextAlign();
    }

    @Override
    public HorizontalTextAlignEnum getOwnHorizontalTextAlign() {
        return ((JRTemplateText)this.template).getOwnHorizontalTextAlign();
    }

    @Override
    public void setHorizontalTextAlign(HorizontalTextAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalTextAlignEnum getVerticalTextAlign() {
        return ((JRTemplateText)this.template).getVerticalTextAlign();
    }

    @Override
    public VerticalTextAlignEnum getOwnVerticalTextAlign() {
        return ((JRTemplateText)this.template).getOwnVerticalTextAlign();
    }

    @Override
    public void setVerticalTextAlign(VerticalTextAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RotationEnum getRotationValue() {
        return ((JRTemplateText)this.template).getRotationValue();
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return ((JRTemplateText)this.template).getOwnRotationValue();
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.runDirectionValue;
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirectionValue) {
        this.runDirectionValue = runDirectionValue;
    }

    @Override
    public Float getAverageCharWidth() {
        return this.averageCharWidth;
    }

    @Override
    public void setAverageCharWidth(Float averageCharWidth) {
        this.averageCharWidth = averageCharWidth;
    }

    @Override
    public float getTextHeight() {
        return this.textHeight;
    }

    @Override
    public void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    @Override
    public String getMarkup() {
        return ((JRTemplateText)this.template).getMarkup();
    }

    @Override
    public String getOwnMarkup() {
        return ((JRTemplateText)this.template).getOwnMarkup();
    }

    @Override
    public void setMarkup(String markup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRLineBox getLineBox() {
        return ((JRTemplateText)this.template).getLineBox();
    }

    @Override
    public JRParagraph getParagraph() {
        return ((JRTemplateText)this.template).getParagraph();
    }

    @Override
    public void setTextFormat(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    @Override
    public String getAnchorName() {
        return this.anchorName;
    }

    @Override
    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    public void setHyperlinkOmitted(boolean hyperlinkOmitted) {
        this.hyperlinkOmitted = hyperlinkOmitted;
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return this.hyperlinkOmitted ? HyperlinkTypeEnum.NONE : ((JRTemplateText)this.template).getHyperlinkTypeValue();
    }

    @Override
    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return ((JRTemplateText)this.template).getHyperlinkTargetValue();
    }

    @Override
    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLinkTarget() {
        return ((JRTemplateText)this.template).getLinkTarget();
    }

    @Override
    public void setLinkTarget(String linkTarget) {
    }

    public void setLinkTarget(byte hyperlinkTarget) {
    }

    @Override
    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    @Override
    public void setHyperlinkReference(String hyperlinkReference) {
        this.hyperlinkReference = hyperlinkReference;
    }

    @Override
    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    @Override
    public void setHyperlinkAnchor(String hyperlinkAnchor) {
        this.hyperlinkAnchor = hyperlinkAnchor;
    }

    @Override
    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    @Override
    public void setHyperlinkPage(Integer hyperlinkPage) {
        this.hyperlinkPage = hyperlinkPage;
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    @Override
    public String getFontName() {
        return ((JRTemplateText)this.template).getFontName();
    }

    @Override
    public String getOwnFontName() {
        return ((JRTemplateText)this.template).getOwnFontName();
    }

    @Override
    public void setFontName(String fontName) {
    }

    @Override
    public boolean isBold() {
        return ((JRTemplateText)this.template).isBold();
    }

    @Override
    public Boolean isOwnBold() {
        return ((JRTemplateText)this.template).isOwnBold();
    }

    @Override
    public void setBold(Boolean isBold) {
    }

    @Override
    public boolean isItalic() {
        return ((JRTemplateText)this.template).isItalic();
    }

    @Override
    public Boolean isOwnItalic() {
        return ((JRTemplateText)this.template).isOwnItalic();
    }

    @Override
    public void setItalic(Boolean isItalic) {
    }

    @Override
    public boolean isUnderline() {
        return ((JRTemplateText)this.template).isUnderline();
    }

    @Override
    public Boolean isOwnUnderline() {
        return ((JRTemplateText)this.template).isOwnUnderline();
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
    }

    @Override
    public boolean isStrikeThrough() {
        return ((JRTemplateText)this.template).isStrikeThrough();
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return ((JRTemplateText)this.template).isOwnStrikeThrough();
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
    }

    @Override
    public float getFontsize() {
        return ((JRTemplateText)this.template).getFontsize();
    }

    @Override
    public Float getOwnFontsize() {
        return ((JRTemplateText)this.template).getOwnFontsize();
    }

    @Override
    public void setFontSize(Float fontSize) {
    }

    @Override
    public String getPdfFontName() {
        return ((JRTemplateText)this.template).getPdfFontName();
    }

    @Override
    public String getOwnPdfFontName() {
        return ((JRTemplateText)this.template).getOwnPdfFontName();
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
    }

    @Override
    public String getPdfEncoding() {
        return ((JRTemplateText)this.template).getPdfEncoding();
    }

    @Override
    public String getOwnPdfEncoding() {
        return ((JRTemplateText)this.template).getOwnPdfEncoding();
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
    }

    @Override
    public boolean isPdfEmbedded() {
        return ((JRTemplateText)this.template).isPdfEmbedded();
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return ((JRTemplateText)this.template).isOwnPdfEmbedded();
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
    }

    @Override
    public String getValueClassName() {
        return this.textFormat == null ? ((JRTemplateText)this.template).getValueClassName() : this.textFormat.getValueClassName();
    }

    @Override
    public String getPattern() {
        return this.textFormat == null ? ((JRTemplateText)this.template).getPattern() : this.textFormat.getPattern();
    }

    @Override
    public String getFormatFactoryClass() {
        return this.textFormat == null ? ((JRTemplateText)this.template).getFormatFactoryClass() : this.textFormat.getFormatFactoryClass();
    }

    @Override
    public String getLocaleCode() {
        return this.textFormat == null ? ((JRTemplateText)this.template).getLocaleCode() : this.textFormat.getLocaleCode();
    }

    @Override
    public String getTimeZoneId() {
        return this.textFormat == null ? ((JRTemplateText)this.template).getTimeZoneId() : this.textFormat.getTimeZoneId();
    }

    @Override
    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public void setHyperlinkParameters(JRPrintHyperlinkParameters hyperlinkParameters) {
        this.hyperlinkParameters = hyperlinkParameters;
    }

    @Override
    public String getLinkType() {
        return this.hyperlinkOmitted ? null : ((JRTemplateText)this.template).getLinkType();
    }

    @Override
    public void setLinkType(String type) {
    }

    @Override
    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    @Override
    public void setHyperlinkTooltip(String hyperlinkTooltip) {
        this.hyperlinkTooltip = hyperlinkTooltip;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.runDirectionValue = RunDirectionEnum.getByValue(this.runDirection);
        }
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        visitor.visit(this, arg);
    }

    @Override
    public void writeVirtualized(VirtualizationOutput out) throws IOException {
        boolean hasValue;
        boolean zeroLineBreakOffsets;
        super.writeVirtualized(out);
        int flags = 0;
        boolean hasAnchor = this.anchorName != null || this.bookmarkLevel != 0;
        boolean hasHyperlink = this.hyperlinkReference != null || this.hyperlinkAnchor != null || this.hyperlinkPage != null || this.hyperlinkTooltip != null || this.hyperlinkParameters != null;
        boolean hasTrunc = this.textTruncateIndex != null || this.textTruncateSuffix != null;
        boolean hasLineBreakOffsets = this.lineBreakOffsets != null;
        boolean bl = zeroLineBreakOffsets = this.lineBreakOffsets != null && this.lineBreakOffsets.length == 0;
        boolean bl2 = !(this.text != null ? this.value instanceof String && this.text.equals(this.value) : this.value == null) ? true : (hasValue = false);
        if (hasAnchor) {
            flags |= 1;
        }
        if (hasHyperlink) {
            flags |= 2;
        }
        if (hasTrunc) {
            flags |= 8;
        }
        if (hasLineBreakOffsets) {
            flags |= 0x10;
        }
        if (zeroLineBreakOffsets) {
            flags |= 0x20;
        }
        if (hasValue) {
            flags |= 0x40;
        }
        if (this.runDirectionValue == RunDirectionEnum.RTL) {
            flags |= 4;
        }
        if (this.hyperlinkOmitted) {
            flags |= 0x80;
        }
        out.writeIntCompressed(flags);
        out.writeJRObject(this.text);
        if (hasValue) {
            out.writeJRObject(this.value);
        }
        out.writeFloat(this.lineSpacingFactor);
        out.writeFloat(this.leadingOffset);
        out.writeFloat(this.textHeight);
        if (hasTrunc) {
            out.writeJRObject(this.textTruncateIndex);
            out.writeJRObject(this.textTruncateSuffix);
        }
        if (hasLineBreakOffsets && !zeroLineBreakOffsets) {
            out.writeIntCompressed(this.lineBreakOffsets.length);
            for (short offset : this.lineBreakOffsets) {
                out.writeIntCompressed(offset);
            }
        }
        if (hasAnchor) {
            out.writeJRObject(this.anchorName);
            out.writeIntCompressed(this.bookmarkLevel);
        }
        if (hasHyperlink) {
            out.writeJRObject(this.hyperlinkReference);
            out.writeJRObject(this.hyperlinkAnchor);
            out.writeJRObject(this.hyperlinkPage);
            out.writeJRObject(this.hyperlinkTooltip);
            out.writeJRObject(this.hyperlinkParameters);
        }
    }

    @Override
    public void readVirtualized(VirtualizationInput in) throws IOException {
        super.readVirtualized(in);
        int flags = in.readIntCompressed();
        this.text = (String)in.readJRObject();
        this.value = (flags & 0x40) != 0 ? in.readJRObject() : this.text;
        this.lineSpacingFactor = in.readFloat();
        this.leadingOffset = in.readFloat();
        this.textHeight = in.readFloat();
        if ((flags & 8) != 0) {
            this.textTruncateIndex = (Integer)in.readJRObject();
            this.textTruncateSuffix = (String)in.readJRObject();
        }
        if ((flags & 0x10) != 0) {
            if ((flags & 0x20) != 0) {
                this.lineBreakOffsets = JRPrintText.ZERO_LINE_BREAK_OFFSETS;
            } else {
                int offsetCount = in.readIntCompressed();
                this.lineBreakOffsets = new short[offsetCount];
                for (int i = 0; i < offsetCount; ++i) {
                    this.lineBreakOffsets[i] = (short)in.readIntCompressed();
                }
            }
        }
        if ((flags & 1) != 0) {
            this.anchorName = (String)in.readJRObject();
            this.bookmarkLevel = in.readIntCompressed();
        } else {
            this.bookmarkLevel = 0;
        }
        if ((flags & 0x80) != 0) {
            this.hyperlinkOmitted = true;
        }
        if ((flags & 2) != 0) {
            this.hyperlinkReference = (String)in.readJRObject();
            this.hyperlinkAnchor = (String)in.readJRObject();
            this.hyperlinkPage = (Integer)in.readJRObject();
            this.hyperlinkTooltip = (String)in.readJRObject();
            this.hyperlinkParameters = (JRPrintHyperlinkParameters)in.readJRObject();
        }
        this.runDirectionValue = (flags & 4) != 0 ? RunDirectionEnum.RTL : RunDirectionEnum.LTR;
        this.PSEUDO_SERIAL_VERSION_UID = 62100;
    }
}

