/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.text.AttributedString;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.export.SimpleAbstractPdfTextRenderer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfTextRendererContext;

public class LineBreaksPdfTextRenderer
extends SimpleAbstractPdfTextRenderer {
    private static final char LINE_BREAK_CHAR = '\u0085';
    private static final String LINE_BREAK_STRING = Character.toString('\u0085');

    public LineBreaksPdfTextRenderer(JasperReportsContext jasperReportsContext, PdfTextRendererContext context) {
        super(jasperReportsContext, context);
    }

    @Override
    public void initialize(JRPdfExporter pdfExporter, PdfProducer pdfProducer, JRPdfExporterTagHelper tagHelper, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        if (text.getLineBreakOffsets() != null) {
            styledText.insert(LINE_BREAK_STRING, text.getLineBreakOffsets());
        }
        super.initialize(pdfExporter, pdfProducer, tagHelper, text, styledText, offsetX, offsetY);
    }

    @Override
    protected void createParagraphPhrase(AttributedString paragraph, String paragraphText) {
        int lineBreakIndex = paragraphText.indexOf(133);
        int lineStart = 0;
        if (lineBreakIndex >= 0) {
            do {
                this.createPhrase(paragraph, lineStart, lineBreakIndex, paragraphText, true);
                lineStart = lineBreakIndex + 1;
            } while ((lineBreakIndex = paragraphText.indexOf(133, lineBreakIndex + 1)) >= 0);
        }
        this.createPhrase(paragraph, lineStart, paragraphText.length(), paragraphText, this.isLastParagraph && this.justifyLastLine);
    }
}

