/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.engine.base.StandardPrintParts;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.StyleResolver;

public class JasperPrint
implements Serializable,
JRPropertiesHolder,
JRChangeEventsSupport {
    public static final String EXCEPTION_MESSAGE_KEY_DUPLICATE_STYLE = "engine.jasper.print.duplicate.style";
    public static final String PROPERTIES_PRINT_TRANSFER_PREFIX = "net.sf.jasperreports.print.transfer.";
    public static final String PROPERTY_CREATE_BOOKMARKS = "net.sf.jasperreports.print.create.bookmarks";
    public static final String PROPERTY_COLLAPSE_MISSING_BOOKMARK_LEVELS = "net.sf.jasperreports.print.collapse.missing.bookmark.levels";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_PAGE_WIDTH = "pageWidth";
    public static final String PROPERTY_PAGE_HEIGHT = "pageHeight";
    public static final String PROPERTY_TOP_MARGIN = "topMargin";
    public static final String PROPERTY_LEFT_MARGIN = "leftMargin";
    public static final String PROPERTY_BOTTOM_MARGIN = "bottomMargin";
    public static final String PROPERTY_RIGHT_MARGIN = "rightMargin";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_STYLES = "styles";
    public static final String PROPERTY_ORIGINS = "origins";
    public static final String PROPERTY_PARTS = "parts";
    public static final String PROPERTY_PAGES = "pages";
    public static final String PROPERTY_BOOKMARKS = "bookmarks";
    public static final String PROPERTY_FORMAT_FACTORY_CLASS = "formatFactoryClass";
    public static final String PROPERTY_LOCALE_CODE = "localeCode";
    public static final String PROPERTY_TIME_ZONE_ID = "timeZoneId";
    private static final long serialVersionUID = 10200L;
    private String name;
    private int pageWidth;
    private int pageHeight;
    private Integer topMargin = 0;
    private Integer leftMargin = 0;
    private Integer bottomMargin = 0;
    private Integer rightMargin = 0;
    private OrientationEnum orientationValue = OrientationEnum.PORTRAIT;
    private transient PrintPageFormat pageFormat;
    private Map<String, JRStyle> stylesMap = new HashMap<String, JRStyle>();
    private List<JRStyle> stylesList = new ArrayList<JRStyle>();
    private Map<JROrigin, Integer> originsMap = new HashMap<JROrigin, Integer>();
    private List<JROrigin> originsList = new ArrayList<JROrigin>();
    private PrintParts parts;
    private List<JRPrintPage> pages;
    private transient Map<String, JRPrintAnchorIndex> anchorIndexes;
    private DefaultStyleProvider defaultStyleProvider = new DefaultStyleProvider(null);
    private String formatFactoryClass;
    private String localeCode;
    private String timeZoneId;
    private JRPropertiesMap propertiesMap = new JRPropertiesMap();
    private List<PrintBookmark> bookmarks;
    private int PSEUDO_SERIAL_VERSION_UID = 62100;
    private byte orientation;
    private transient JRPropertyChangeSupport eventSupport;

    public JasperPrint() {
        this(new ArrayList<JRPrintPage>());
    }

    protected JasperPrint(List<JRPrintPage> pages) {
        this.pages = Collections.synchronizedList(pages);
    }

    public synchronized void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.defaultStyleProvider.setJasperReportsContext(jasperReportsContext);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_NAME, old, this.name);
        }
    }

    public PrintPageFormat getPageFormat(int pageIndex) {
        if (this.parts == null || !this.parts.hasParts()) {
            return this.getPageFormat();
        }
        PrintPageFormat partPageFormat = this.parts.getPageFormat(pageIndex);
        if (partPageFormat == null) {
            return this.getPageFormat();
        }
        return partPageFormat;
    }

    public synchronized PrintPageFormat getPageFormat() {
        if (this.pageFormat == null) {
            this.pageFormat = new DefaultPrintPageFormat();
        }
        return this.pageFormat;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        Integer old = this.pageWidth;
        this.pageWidth = pageWidth;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_PAGE_WIDTH, old, (Object)this.pageWidth);
        }
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        Integer old = this.pageHeight;
        this.pageHeight = pageHeight;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_PAGE_HEIGHT, old, (Object)this.pageHeight);
        }
    }

    public Integer getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Integer topMargin) {
        Integer old = this.topMargin;
        this.topMargin = topMargin;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_TOP_MARGIN, old, this.topMargin);
        }
    }

    public Integer getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Integer leftMargin) {
        Integer old = this.leftMargin;
        this.leftMargin = leftMargin;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_LEFT_MARGIN, old, this.leftMargin);
        }
    }

    public Integer getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Integer bottomMargin) {
        Integer old = this.bottomMargin;
        this.bottomMargin = bottomMargin;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_BOTTOM_MARGIN, old, this.bottomMargin);
        }
    }

    public Integer getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Integer rightMargin) {
        Integer old = this.rightMargin;
        this.rightMargin = rightMargin;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_RIGHT_MARGIN, old, this.rightMargin);
        }
    }

    public OrientationEnum getOrientationValue() {
        return this.orientationValue;
    }

    public void setOrientation(OrientationEnum orientationValue) {
        OrientationEnum old = this.orientationValue;
        this.orientationValue = orientationValue;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, old, this.orientationValue);
        }
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public String[] getPropertyNames() {
        return this.propertiesMap.getPropertyNames();
    }

    public String getProperty(String propName) {
        return this.propertiesMap.getProperty(propName);
    }

    public void setProperty(String propName, String value) {
        this.propertiesMap.setProperty(propName, value);
    }

    public void removeProperty(String propName) {
        this.propertiesMap.removeProperty(propName);
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyleProvider.getDefaultStyle();
    }

    public synchronized void setDefaultStyle(JRStyle style) {
        this.defaultStyleProvider.setDefaultStyle(style);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle[] getStyles() {
        JRStyle[] stylesArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(stylesArray);
        return stylesArray;
    }

    public List<JRStyle> getStylesList() {
        return this.stylesList;
    }

    public Map<String, JRStyle> getStylesMap() {
        return this.stylesMap;
    }

    public synchronized void addStyle(JRStyle style) throws JRException {
        this.addStyle(style, false);
    }

    public synchronized void addStyle(JRStyle style, boolean isIgnoreDuplicate) throws JRException {
        if (this.stylesMap.containsKey(style.getName())) {
            if (!isIgnoreDuplicate) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_STYLE, style.getName());
            }
        } else {
            this.stylesList.add(style);
            this.stylesMap.put(style.getName(), style);
            if (style.isDefault()) {
                this.setDefaultStyle(style);
            }
            if (this.hasEventSupport()) {
                this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_STYLES, style, this.stylesList.size() - 1);
            }
        }
    }

    public synchronized JRStyle removeStyle(String styleName) {
        return this.removeStyle(this.stylesMap.get(styleName));
    }

    public synchronized JRStyle removeStyle(JRStyle style) {
        if (style != null) {
            if (style.isDefault()) {
                this.setDefaultStyle(null);
            }
            boolean removed = this.stylesList.remove(style);
            this.stylesMap.remove(style.getName());
            if (removed && this.hasEventSupport()) {
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_STYLES, style, -1);
            }
        }
        return style;
    }

    public JROrigin[] getOrigins() {
        return this.originsList.toArray(new JROrigin[this.originsList.size()]);
    }

    public List<JROrigin> getOriginsList() {
        return this.originsList;
    }

    public Map<JROrigin, Integer> getOriginsMap() {
        return this.originsMap;
    }

    public synchronized void addOrigin(JROrigin origin) {
        if (!this.originsMap.containsKey(origin)) {
            this.originsList.add(origin);
            this.originsMap.put(origin, this.originsList.size() - 1);
            if (this.hasEventSupport()) {
                this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ORIGINS, origin, this.originsList.size() - 1);
            }
        }
    }

    public synchronized JROrigin removeOrigin(JROrigin origin) {
        if (this.originsMap.containsKey(origin)) {
            this.originsList.remove(origin);
            this.originsMap = new HashMap<JROrigin, Integer>();
            for (int i = 0; i < this.originsList.size(); ++i) {
                this.originsMap.put(this.originsList.get(i), i);
            }
            if (this.hasEventSupport()) {
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ORIGINS, origin, -1);
            }
        }
        return origin;
    }

    public boolean hasParts() {
        return this.parts != null && this.parts.hasParts();
    }

    public PrintParts getParts() {
        return this.parts;
    }

    public synchronized void addPart(int pageIndex, PrintPart part) {
        if (this.parts == null) {
            this.parts = new StandardPrintParts();
        }
        this.parts.addPart(pageIndex, part);
        if (this.hasEventSupport()) {
            this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARTS, part, pageIndex);
        }
    }

    public synchronized PrintPart removePart(int pageIndex) {
        if (this.parts == null) {
            return null;
        }
        PrintPart part = this.parts.removePart(pageIndex);
        if (part != null && this.hasEventSupport()) {
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARTS, part, pageIndex);
        }
        return part;
    }

    public List<JRPrintPage> getPages() {
        return this.pages;
    }

    public synchronized void addPage(JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(page);
        if (this.hasEventSupport()) {
            this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PAGES, page, this.pages.size() - 1);
        }
    }

    public synchronized void addPage(int index, JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(index, page);
        if (this.hasEventSupport()) {
            this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PAGES, page, index);
        }
    }

    public synchronized JRPrintPage removePage(int index) {
        this.anchorIndexes = null;
        JRPrintPage page = this.pages.remove(index);
        if (page != null && this.hasEventSupport()) {
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PAGES, page, index);
        }
        return page;
    }

    public List<PrintBookmark> getBookmarks() {
        return this.bookmarks;
    }

    public synchronized void addBookmark(PrintBookmark bookmark) {
        if (this.bookmarks == null) {
            this.bookmarks = new ArrayList<PrintBookmark>();
        }
        this.bookmarks.add(bookmark);
        if (this.hasEventSupport()) {
            this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_BOOKMARKS, bookmark, this.bookmarks.size() - 1);
        }
    }

    public void setBookmarks(List<PrintBookmark> bookmarks) {
        List<PrintBookmark> old = this.bookmarks;
        this.bookmarks = bookmarks;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARKS, old, this.bookmarks);
        }
    }

    public synchronized Map<String, JRPrintAnchorIndex> getAnchorIndexes() {
        if (this.anchorIndexes == null) {
            this.anchorIndexes = new HashMap<String, JRPrintAnchorIndex>();
            int i = 0;
            for (JRPrintPage page : this.pages) {
                List<JRPrintElement> elements = page.getElements();
                this.collectAnchors(elements, i, 0, 0);
                ++i;
            }
        }
        return this.anchorIndexes;
    }

    protected void collectAnchors(Collection<JRPrintElement> elements, int pageIndex, int offsetX, int offsetY) {
        if (elements != null && elements.size() > 0) {
            JRPrintElement element2 = null;
            for (JRPrintElement element2 : elements) {
                if (element2 instanceof JRPrintAnchor) {
                    this.anchorIndexes.put(((JRPrintAnchor)((Object)element2)).getAnchorName(), new JRPrintAnchorIndex(pageIndex, element2, offsetX, offsetY));
                }
                if (!(element2 instanceof JRPrintFrame)) continue;
                JRPrintFrame frame = (JRPrintFrame)element2;
                this.collectAnchors(frame.getElements(), pageIndex, offsetX + frame.getX(), offsetY + frame.getY());
            }
        }
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        String old = this.formatFactoryClass;
        this.formatFactoryClass = formatFactoryClass;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_FORMAT_FACTORY_CLASS, old, this.formatFactoryClass);
        }
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        String old = this.localeCode;
        this.localeCode = localeCode;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_LOCALE_CODE, old, this.localeCode);
        }
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        String old = this.timeZoneId;
        this.timeZoneId = timeZoneId;
        if (this.hasEventSupport()) {
            this.getEventSupport().firePropertyChange(PROPERTY_TIME_ZONE_ID, old, this.timeZoneId);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.orientationValue = OrientationEnum.getByValue(this.orientation);
        }
    }

    public void copyFrom(JasperPrint jasperPrint) {
        this.name = jasperPrint.name;
        this.pageWidth = jasperPrint.pageWidth;
        this.pageHeight = jasperPrint.pageHeight;
        this.topMargin = jasperPrint.topMargin;
        this.leftMargin = jasperPrint.leftMargin;
        this.bottomMargin = jasperPrint.bottomMargin;
        this.rightMargin = jasperPrint.rightMargin;
        this.orientationValue = jasperPrint.orientationValue;
        this.formatFactoryClass = jasperPrint.formatFactoryClass;
        this.localeCode = jasperPrint.localeCode;
        this.timeZoneId = jasperPrint.timeZoneId;
        if (jasperPrint.propertiesMap != null) {
            this.propertiesMap = jasperPrint.propertiesMap.cloneProperties();
        }
        this.stylesList.addAll(jasperPrint.stylesList);
        this.stylesMap.putAll(jasperPrint.stylesMap);
        this.defaultStyleProvider.setDefaultStyle(jasperPrint.defaultStyleProvider.getDefaultStyle());
        this.originsList.addAll(jasperPrint.originsList);
        this.originsMap.putAll(jasperPrint.originsMap);
        if (jasperPrint.bookmarks != null) {
            this.bookmarks = new ArrayList<PrintBookmark>(jasperPrint.bookmarks);
        }
        if (jasperPrint.parts != null) {
            this.parts = ((StandardPrintParts)jasperPrint.parts).shallowClone();
        }
        this.pages.addAll(jasperPrint.pages);
    }

    protected boolean hasEventSupport() {
        return this.eventSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JasperPrint jasperPrint = this;
        synchronized (jasperPrint) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private static class DefaultStyleProvider
    implements JRDefaultStyleProvider,
    Serializable {
        private static final long serialVersionUID = 10200L;
        private JRStyle defaultStyle;
        protected transient StyleResolver styleResolver = StyleResolver.getInstance();

        DefaultStyleProvider(JRStyle style) {
            this.defaultStyle = style;
        }

        @Override
        public JRStyle getDefaultStyle() {
            return this.defaultStyle;
        }

        void setDefaultStyle(JRStyle style) {
            this.defaultStyle = style;
        }

        public synchronized void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
            this.styleResolver = new StyleResolver(jasperReportsContext);
        }

        @Override
        public StyleResolver getStyleResolver() {
            return this.styleResolver;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.styleResolver = StyleResolver.getInstance();
        }
    }

    private class DefaultPrintPageFormat
    implements PrintPageFormat {
        private DefaultPrintPageFormat() {
        }

        @Override
        public Integer getPageWidth() {
            return JasperPrint.this.getPageWidth();
        }

        @Override
        public Integer getPageHeight() {
            return JasperPrint.this.getPageHeight();
        }

        @Override
        public Integer getTopMargin() {
            return JasperPrint.this.getTopMargin();
        }

        @Override
        public Integer getLeftMargin() {
            return JasperPrint.this.getLeftMargin();
        }

        @Override
        public Integer getBottomMargin() {
            return JasperPrint.this.getBottomMargin();
        }

        @Override
        public Integer getRightMargin() {
            return JasperPrint.this.getRightMargin();
        }

        @Override
        public OrientationEnum getOrientation() {
            return JasperPrint.this.getOrientationValue();
        }
    }
}

