/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.Serializable;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.compilers.JavaScriptCompiledData;
import net.sf.jasperreports.compilers.JavaScriptCompiledEvaluator;
import net.sf.jasperreports.compilers.JavaScriptEvaluator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.ExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.EvaluatorException;

public abstract class JavaScriptCompilerBase
extends JRAbstractCompiler {
    private static final Log log = LogFactory.getLog(JavaScriptCompilerBase.class);
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_COMPILE_DATA_TYPE = "compilers.invalid.data.type";

    protected JavaScriptCompilerBase(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return null;
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".js";
    }

    @Override
    protected JREvaluator loadEvaluator(Serializable compileData, String unitName) throws JRException {
        if (compileData instanceof JavaScriptCompileData) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JavaScriptCompileData found for " + unitName));
            }
            JavaScriptCompileData jsCompileData = (JavaScriptCompileData)compileData;
            return new JavaScriptEvaluator(this.jasperReportsContext, jsCompileData);
        }
        if (compileData instanceof JavaScriptCompiledData) {
            JavaScriptCompiledData jsCompiledData = (JavaScriptCompiledData)compileData;
            return new JavaScriptCompiledEvaluator(this.jasperReportsContext, unitName, jsCompiledData);
        }
        throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_COMPILE_DATA_TYPE, compileData.getClass().getName());
    }

    protected ScriptExpressionVisitor defaultExpressionCreator() {
        return new ScriptExpressionVisitor("getValue", "getValue");
    }

    protected ScriptExpressionVisitor oldExpressionCreator() {
        return new ScriptExpressionVisitor("getOldValue", "getOldValue");
    }

    protected ScriptExpressionVisitor estimatedExpressionCreator() {
        return new ScriptExpressionVisitor("getValue", "getEstimatedValue");
    }

    protected static String getParameterVar(String name) {
        return "param_" + JRStringUtil.getJavaIdentifier(name);
    }

    protected static String getVariableVar(String name) {
        return "var_" + JRStringUtil.getJavaIdentifier(name);
    }

    protected static String getFieldVar(String name) {
        return "field_" + JRStringUtil.getJavaIdentifier(name);
    }

    protected static class ScriptExpressionVisitor
    implements ExpressionChunkVisitor {
        private final String fieldMethod;
        private final String variableMethod;
        protected final StringBuilder script = new StringBuilder();

        public ScriptExpressionVisitor(String fieldMethod, String variableMethod) {
            this.fieldMethod = fieldMethod;
            this.variableMethod = variableMethod;
        }

        public String getScript() {
            if (this.script.length() == 0) {
                return "null";
            }
            return this.script.toString();
        }

        @Override
        public void visitTextChunk(JRExpressionChunk chunk) {
            this.script.append(chunk.getText());
        }

        @Override
        public void visitParameterChunk(JRExpressionChunk chunk) {
            String paramName = JavaScriptCompilerBase.getParameterVar(chunk.getText());
            this.script.append(paramName);
            this.script.append(".getValue()");
        }

        @Override
        public void visitFieldChunk(JRExpressionChunk chunk) {
            String fieldName = JavaScriptCompilerBase.getFieldVar(chunk.getText());
            this.script.append(fieldName).append('.').append(this.fieldMethod).append("()");
        }

        @Override
        public void visitVariableChunk(JRExpressionChunk chunk) {
            String varName = JavaScriptCompilerBase.getVariableVar(chunk.getText());
            this.script.append(varName).append('.').append(this.variableMethod).append("()");
        }

        @Override
        public void visitResourceChunk(JRExpressionChunk chunk) {
            String key = chunk.getText();
            this.script.append("_jreval");
            this.script.append(".str('");
            this.script.append(JRStringUtil.escapeJavaScript(key));
            this.script.append("')");
        }
    }

    protected static class Errors {
        private final StringBuilder errors = new StringBuilder();
        private int errorCount = 0;

        protected Errors() {
        }

        public void addError(EvaluatorException error) {
            ++this.errorCount;
            this.errors.append(this.errorCount);
            this.errors.append(". ");
            String message = error.getMessage();
            this.errors.append(message);
            this.errors.append(" at column ");
            this.errors.append(error.columnNumber());
            String lineSource = error.lineSource();
            if (lineSource != null) {
                this.errors.append(" in line\n");
                this.errors.append(lineSource);
            }
            this.errors.append("\n");
        }

        public boolean hasErrors() {
            return this.errorCount > 0;
        }

        public String errorMessage() {
            String errorsMessage = null;
            if (this.errorCount > 0) {
                errorsMessage = this.errorCount + " error(s):\n" + this.errors;
            }
            return errorsMessage;
        }
    }
}

