/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import com.hierynomus.asn1.ASN1InputStream;
import com.hierynomus.asn1.ASN1OutputStream;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.ASN1Encoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.encodingrules.der.DEREncoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.ArrayList;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;

public class SignatureECDSA
extends AbstractSignature {
    private String keyTypeName;

    public SignatureECDSA(String algorithm, String keyTypeName) {
        super(algorithm, keyTypeName);
        this.keyTypeName = keyTypeName;
    }

    @Override
    public byte[] encode(byte[] sig) {
        ByteArrayInputStream bais = new ByteArrayInputStream(sig);
        ASN1InputStream asn1InputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), (InputStream)bais);
        ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
        ASN1Integer r = (ASN1Integer)sequence.get(0);
        ASN1Integer s = (ASN1Integer)sequence.get(1);
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        buf.putMPInt(r.getValue());
        buf.putMPInt(s.getValue());
        return buf.getCompactData();
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            byte[] sigBlob = this.extractSig(sig, this.keyTypeName);
            return this.signature.verify(this.asnEncode(sigBlob));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
        catch (IOException e) {
            throw new SSHRuntimeException(e);
        }
    }

    private byte[] asnEncode(byte[] sigBlob) throws IOException {
        Buffer.PlainBuffer sigbuf = new Buffer.PlainBuffer(sigBlob);
        BigInteger r = sigbuf.readMPInt();
        BigInteger s = sigbuf.readMPInt();
        ArrayList<ASN1Integer> vector = new ArrayList<ASN1Integer>();
        vector.add(new ASN1Integer(r));
        vector.add(new ASN1Integer(s));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream asn1OutputStream = new ASN1OutputStream((ASN1Encoder)new DEREncoder(), (OutputStream)baos);
        asn1OutputStream.writeObject((ASN1Object)new ASN1Sequence(vector));
        asn1OutputStream.flush();
        return baos.toByteArray();
    }

    public static class Factory521
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA512withECDSA", KeyType.ECDSA521.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA521.toString();
        }
    }

    public static class Factory384
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA384withECDSA", KeyType.ECDSA384.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA384.toString();
        }
    }

    public static class Factory256
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA256withECDSA", KeyType.ECDSA256.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA256.toString();
        }
    }
}

