/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.bgerp.util.Log;
import org.bgerp.util.sql.pool.ConnectionPool;
import org.bgerp.util.sql.pool.fakesql.FakeConnection;

public class ConnectionSet
implements AutoCloseable {
    private static final Log log = Log.getLog();
    public static final String KEY = "conSet";
    public static final int TYPE_MASTER = 1;
    public static final int TYPE_SLAVE = 2;
    public static final int TYPE_TRASH = 3;
    public static final int TYPE_FAKE = 4;
    private final ConnectionPool pool;
    private final boolean internalMaster;
    private final boolean autoCommit;
    private volatile Connection masterConnection;
    private volatile Connection slaveConnection;
    private volatile Map<String, Connection[]> trashConnections;

    public ConnectionSet(ConnectionPool setup, boolean autoCommit) {
        this.pool = setup;
        this.internalMaster = true;
        this.autoCommit = autoCommit;
    }

    protected ConnectionSet(Connection master) {
        this.pool = null;
        this.internalMaster = false;
        this.autoCommit = false;
        this.masterConnection = master;
    }

    public Connection getConnection() {
        if (this.masterConnection == null) {
            this.masterConnection = this.newMasterConnection();
        }
        return this.masterConnection;
    }

    private Connection newMasterConnection() {
        Connection result = this.pool.getDBConnectionFromPool();
        try {
            if (result != null && result.getAutoCommit() != this.autoCommit) {
                result.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException ex) {
            log.error(ex);
        }
        return result;
    }

    public Connection getSlaveConnection() {
        if (this.slaveConnection == null) {
            this.slaveConnection = this.newSlaveConnection();
            if (this.slaveConnection == null) {
                this.slaveConnection = this.getConnection();
            }
        }
        return this.slaveConnection;
    }

    private Connection newSlaveConnection() {
        return this.pool.getDBSlaveConnectionFromPool(this.getConnection());
    }

    public Connection getTrashConnection(String tableName, int defaultType) {
        Connection connection;
        Connection[] connections;
        if (this.trashConnections == null) {
            this.trashConnections = new HashMap<String, Connection[]>();
        }
        if ((connections = this.trashConnections.get(tableName)) == null) {
            connections = new Connection[4];
            this.trashConnections.put(tableName, connections);
        }
        if ((connection = connections[0]) == null && (connection = this.newTrashConnection(tableName)) == null && (connection = connections[defaultType]) == null) {
            switch (defaultType) {
                case 2: {
                    connections[2] = connection = this.getSlaveConnection();
                    break;
                }
                case 4: {
                    connections[4] = connection = new FakeConnection();
                    break;
                }
                default: {
                    connections[1] = connection = this.getConnection();
                }
            }
        }
        return connection;
    }

    private Connection newTrashConnection(String tableName) {
        Connection result = this.pool.getDBTrashConnectionFromPool(tableName, -1);
        try {
            if (result != null && result.getAutoCommit() != this.autoCommit) {
                result.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException ex) {
            log.error(ex);
        }
        return result;
    }

    public void commit() throws SQLException {
        if (this.masterConnection != null && !this.masterConnection.getAutoCommit()) {
            this.masterConnection.commit();
        }
        if (this.trashConnections != null) {
            HashSet<Connection> commited = new HashSet<Connection>();
            Iterator<Connection[]> iterator = this.trashConnections.values().iterator();
            while (iterator.hasNext()) {
                for (Connection connection : iterator.next()) {
                    if (connection == null || connection == this.slaveConnection || connection == this.masterConnection || connection.getAutoCommit() || !commited.add(connection)) continue;
                    connection.commit();
                }
            }
        }
    }

    public void rollback() {
        if (this.trashConnections != null) {
            Iterator<Connection[]> iterator = this.trashConnections.values().iterator();
            while (iterator.hasNext()) {
                for (Connection connection : iterator.next()) {
                    if (connection == null || connection == this.slaveConnection || connection == this.masterConnection) continue;
                    try {
                        connection.rollback();
                    }
                    catch (Exception e) {
                        log.error(e);
                    }
                }
            }
        }
        if (this.masterConnection != null) {
            try {
                this.masterConnection.rollback();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    @Override
    public void close() {
        if (this.trashConnections != null) {
            Iterator<Connection[]> iterator = this.trashConnections.values().iterator();
            while (iterator.hasNext()) {
                for (Connection connection : iterator.next()) {
                    if (connection == null || connection == this.slaveConnection || connection == this.masterConnection) continue;
                    try {
                        if (!connection.isClosed()) {
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        log.error(e);
                    }
                    connections[i] = null;
                }
            }
            this.trashConnections.clear();
        }
        if (this.slaveConnection != null) {
            if (this.slaveConnection != this.masterConnection) {
                try {
                    if (!this.slaveConnection.isClosed()) {
                        this.slaveConnection.close();
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            this.slaveConnection = null;
        }
        if (this.masterConnection != null) {
            if (this.internalMaster) {
                try {
                    if (!this.masterConnection.isClosed()) {
                        this.masterConnection.close();
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            this.masterConnection = null;
        }
    }

    @Deprecated
    public void recycle() {
        log.warndMethod("recycle", "close");
    }
}

