/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class RegexpCheckerConfig
extends Config {
    private static final Log log = Log.getLog();
    private List<Pattern> regexpList;
    private String regexpTitles = "";

    public RegexpCheckerConfig(ConfigMap config) {
        super(null);
        for (ConfigMap value : config.subIndexed("regexp.").values()) {
            String title = value.get("title");
            String regexp = value.get("regexp");
            if (Utils.isBlankString(title)) continue;
            try {
                Pattern pattern = Pattern.compile(regexp);
                if (this.regexpList == null) {
                    this.regexpList = new ArrayList<Pattern>();
                }
                this.regexpList.add(pattern);
                if (Utils.notBlankString(this.regexpTitles)) {
                    this.regexpTitles = this.regexpTitles + "\n";
                }
                this.regexpTitles = this.regexpTitles + title;
            }
            catch (Exception e) {
                log.error("Regexp pattern load: " + e.getMessage() + ". Title: " + title + "; regexp: " + regexp, new Object[0]);
            }
        }
    }

    public void checkValue(String value) throws BGMessageException {
        if (this.regexpList != null) {
            for (Pattern p : this.regexpList) {
                if (!p.matcher(value).matches()) continue;
                return;
            }
            throw new BGMessageException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043e\u0434\u043d\u043e\u043c\u0443 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432: {}", this.regexpTitles);
        }
    }
}

