/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bgcrm.util.Utils;

public class PatternFormatter {
    private static final String BEFORE_VAR = "\\(([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\s\\[\\]\\\\/#\\(\\)]*)\\$\\{";
    private static final String AFTER_VAR = "\\}([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\s\\[\\]\\\\/#\\(\\)]*)\\)";
    private static final Pattern VAR_PATTERN = Pattern.compile("\\(([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\s\\[\\]\\\\/#\\(\\)]*)\\$\\{([\\w:]+)\\}([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\s\\[\\]\\\\/#\\(\\)]*)\\)");

    public static String processPattern(String pattern, Function<String, String> processor) {
        StringBuilder result = new StringBuilder(pattern.length());
        int pos = 0;
        Matcher m = VAR_PATTERN.matcher(pattern);
        while (m.find()) {
            result.append(pattern.substring(pos, m.start()));
            String value = processor.apply(m.group(2));
            if (Utils.notBlankString(value)) {
                String prefix = m.group(1);
                if (prefix.startsWith(",") && result.length() == 0) {
                    prefix = prefix.substring(1);
                }
                result.append(prefix);
                result.append(value);
                result.append(m.group(3));
            }
            pos = m.end();
        }
        result.append(pattern.substring(pos));
        return result.toString();
    }

    public static String processPattern(String pattern, Map<String, String> values) {
        return PatternFormatter.processPattern(pattern, (String key) -> (String)values.get(key));
    }
}

