/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action.admin;

import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.cache.CustomerGroupCache;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.CustomerGroupDAO;
import ru.bgcrm.model.customer.CustomerGroup;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/customer")
public class CustomerAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/customer/group";

    public ActionForward groupList(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerGroupDAO customerGroupDAO = new CustomerGroupDAO(conSet.getConnection());
        customerGroupDAO.searchGroup(new Pageable<CustomerGroup>(form));
        return this.html(conSet, form, "/WEB-INF/jspf/admin/customer/group/list.jsp");
    }

    public ActionForward groupGet(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerGroup group = new CustomerGroupDAO(conSet.getConnection()).getGroupById(form.getId());
        if (group != null) {
            form.setResponseData("group", group);
        }
        return this.html(conSet, form, "/WEB-INF/jspf/admin/customer/group/update.jsp");
    }

    public ActionForward groupUpdate(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerGroupDAO customerGroupDAO = new CustomerGroupDAO(conSet.getConnection());
        CustomerGroup group = new CustomerGroup();
        group.setId(form.getId());
        group.setTitle(form.getParam("title", ""));
        group.setComment(form.getParam("comment", ""));
        customerGroupDAO.updateGroup(group);
        CustomerGroupCache.flush(conSet.getConnection());
        return this.json(conSet, form);
    }

    public ActionForward groupDelete(DynActionForm form, ConnectionSet conSet) throws Exception {
        CustomerGroupDAO customerGroupDAO = new CustomerGroupDAO(conSet.getConnection());
        customerGroupDAO.deleteGroup(form.getId());
        CustomerGroupCache.flush(conSet.getConnection());
        return this.json(conSet, form);
    }
}

