/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.ProcessLinkProcessAction;
import org.bgerp.app.cfg.SimpleConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.ProcessQueueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.process.config.ProcessCreateInConfig;
import org.bgerp.model.process.queue.filter.FilterLinkObject;
import org.bgerp.model.process.queue.filter.FilterList;
import org.bgerp.model.process.queue.filter.FilterOpenClose;
import org.bgerp.model.process.queue.filter.FilterProcessType;
import org.bgerp.util.Log;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.client.ProcessOpenEvent;
import ru.bgcrm.event.link.LinkAddedEvent;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.ProcessAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/process/link")
public class ProcessLinkAction
extends ProcessAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/process/process/link";

    public ActionForward linkedProcessList(DynActionForm form, Connection con) throws Exception {
        ProcessLinkDAO processLinkDAO = new ProcessLinkDAO(con, form);
        this.restoreRequestParams(con, form, true, true, "open");
        String objectType = form.getParam("objectType");
        int id = form.getId();
        Boolean paramOpen = form.getParamBoolean("open", null);
        Set<Integer> paramProcessTypeId = form.getParamValues("typeId");
        Queue queue = ProcessQueueCache.getQueue(this.setup.getInt(objectType + ".processes.queue"));
        if (queue != null) {
            queue = queue.clone();
            FilterList filters = queue.getFilterList();
            filters.add(new FilterLinkObject(0, SimpleConfigMap.of(new Object[]{"values", String.valueOf(id)}), objectType, "id"));
            if (paramOpen != null) {
                filters.add(new FilterOpenClose(0, SimpleConfigMap.of(new Object[]{"values", paramOpen != false ? "open" : "close"})));
            }
            if (!paramProcessTypeId.isEmpty()) {
                filters.add(new FilterProcessType(0, SimpleConfigMap.of(new Object[]{"onEmptyValues", Utils.toString(paramProcessTypeId)})));
            }
            Pageable<Object[]> searchResult = new Pageable<Object[]>(form);
            new ProcessQueueDAO(con, form).searchProcess(searchResult, null, queue, form);
            List<Object[]> list = searchResult.getList();
            HttpServletRequest request = form.getHttpRequest();
            request.setAttribute("columnList", queue.getMediaColumnList("html"));
            queue.replaceRowsForMedia(form, "html", list);
            request.setAttribute("queue", (Object)queue);
        } else {
            Pageable<Pair<String, Process>> searchResult = new Pageable<Pair<String, Process>>(form);
            processLinkDAO.searchLinkedProcessList(searchResult, LikePattern.START.get(objectType), id, null, paramProcessTypeId, form.getParamValues("statusId"), form.getParam("paramFilter"), paramOpen);
        }
        form.setResponseData("typeList", processLinkDAO.getLinkedProcessTypeIdList(objectType, id));
        List<ProcessType> typeList = ProcessLinkAction.processTypeIsolationFilter(ProcessTypeCache.getTypeList("linked", objectType, null), form);
        form.setRequestAttribute("typeTreeRoot", ProcessTypeCache.getTypeTreeRoot().sub(typeList));
        return this.html(con, form, "/WEB-INF/jspf/user/process/process/link/linked_process_list.jsp");
    }

    public ActionForward linkedProcessCreate(DynActionForm form, Connection con) throws Exception {
        String objectType = form.getParam("objectType");
        int id = form.getId();
        String objectTitle = form.getParam("objectTitle");
        Process process = ProcessAction.processCreateAndGet(form, con);
        CommonObjectLink link = new CommonObjectLink("process", process.getId(), objectType, id, objectTitle);
        EventProcessor.processEvent(new LinkAddingEvent(form, link), new SingleConnectionSet(con));
        new ProcessLinkDAO(con).addLink(link);
        EventProcessor.processEvent(new LinkAddedEvent(form, link), new SingleConnectionSet(con));
        ProcessType type = ProcessTypeCache.getProcessTypeOrThrow(form.getParamInt("typeId", 0));
        ProcessCreateInConfig config = type.getProperties().getConfigMap().getConfig(ProcessCreateInConfig.class);
        new ParamValueDAO(con).copyParams(id, (int)process.getId(), config.getCopyParams());
        if (config.openCreated(objectType) || type.getProperties().getWizard() != null && type.getProperties().getWizard().getCreateStepList().size() > 0) {
            form.getResponse().addEvent(new ProcessOpenEvent(process.getId()));
        }
        return this.json(con, form);
    }

    @Deprecated
    public static Process linkProcessCreate(Connection con, DynActionForm form, Process linkedProcess, int typeId, String objectType, int createTypeId, String description, int groupId) throws Exception {
        log.warnd("linkProcessCreate", "ProcessLinkProcessAction.linkProcessCreate");
        return ProcessLinkProcessAction.linkProcessCreate(con, form, linkedProcess, typeId, objectType, createTypeId, description, groupId);
    }
}

