/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.document.dao;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.FileDataDAO;
import ru.bgcrm.model.FileData;
import ru.bgcrm.plugin.document.model.Document;

public class DocumentDAO
extends CommonDAO {
    private static String TABLE_DOCUMENT = " document ";

    public DocumentDAO(Connection con) {
        super(con);
    }

    public void add(String objectType, int objectId, byte[] data, String title) {
        try {
            FileData fileData = new FileData();
            fileData.setTitle(title);
            FileOutputStream fos = new FileDataDAO(this.con).add(fileData);
            fos.write(data);
            fos.close();
            Document doc = new Document();
            doc.setFileDataId(fileData.getId());
            doc.setFileData(fileData);
            doc.setObjectId(objectId);
            doc.setObjectType(objectType);
            this.add(doc);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void add(Document b) throws SQLException {
        String query = "INSERT INTO " + TABLE_DOCUMENT + " (object_type, object_id, file_data_id)  VALUES (?,?,?) ";
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        ps.setString(1, b.getObjectType());
        ps.setInt(2, b.getObjectId());
        ps.setInt(3, b.getFileDataId());
        ps.executeUpdate();
        b.setId(this.lastInsertId(ps));
        ps.close();
    }

    public void delete(Document doc) throws Exception {
        this.deleteById(TABLE_DOCUMENT, doc.getId());
        if (doc.getFileData() != null) {
            new FileDataDAO(this.con).delete(doc.getFileData());
        }
    }

    public Document getDocumentById(int id) {
        Document result = null;
        String query = "SELECT  doc.*, fd.*   FROM " + TABLE_DOCUMENT + " AS doc  INNER JOIN  file_data  AS fd ON doc.file_data_id=fd.id  WHERE  doc.id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = DocumentDAO.getFromRS(rs, "doc.");
                result.setFileData(FileDataDAO.getFromRs(rs, "fd."));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void searchObjectDocuments(Pageable<Document> result, String objectType, int objectId) {
        List<Document> list = result.getList();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT d.*, f.* FROM " + TABLE_DOCUMENT + "AS d INNER JOIN  file_data AS f ON d.file_data_id=f.id WHERE d.object_type=? AND d.object_id=? ORDER BY d.id");
            ps.setString(1, objectType);
            ps.setInt(2, objectId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document doc = DocumentDAO.getFromRS(rs, "d.");
                doc.setFileData(FileDataDAO.getFromRs(rs, "f."));
                list.add(doc);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public OutputStream createDocumentFile(Document doc, String title) throws Exception {
        FileDataDAO fileDao = new FileDataDAO(this.con);
        DocumentDAO docDao = new DocumentDAO(this.con);
        FileData file = new FileData();
        file.setTitle(title);
        FileOutputStream out = fileDao.add(file);
        doc.setFileDataId(file.getId());
        docDao.add(doc);
        return out;
    }

    public static Document getFromRS(ResultSet rs, String prefix) throws SQLException {
        Document doc = new Document();
        doc.setId(rs.getInt(prefix + "id"));
        doc.setObjectType(rs.getString(prefix + "object_type"));
        doc.setObjectId(rs.getInt(prefix + "object_id"));
        doc.setFileDataId(rs.getInt(prefix + "file_data_id"));
        return doc;
    }
}

