/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.model.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttr;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntitySpecAttrType;
import ru.bgcrm.util.Utils;

public class EntityAttrPhone
extends EntityAttr {
    private String data;
    private List<PhoneContact> contactList;

    protected EntityAttrPhone() {
        super(EntitySpecAttrType.PHONE);
    }

    public EntityAttrPhone(int entityId, int entitySpecAttrId) {
        super(EntitySpecAttrType.PHONE, entityId, entitySpecAttrId);
    }

    public EntityAttrPhone(int entityId, int entitySpecAttrId, String phone, String comment) {
        this(entityId, entitySpecAttrId);
        this.addContact(phone, comment);
    }

    public List<PhoneContact> getContactList() {
        return this.contactList;
    }

    public void setContactList(List<PhoneContact> phoneList) {
        this.contactList = phoneList;
    }

    public EntityAttrPhone addContact(String phone, String comment) {
        if (this.contactList == null) {
            this.contactList = new ArrayList<PhoneContact>();
        }
        this.contactList.add(new PhoneContact(phone, comment));
        return this;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getContactList() != null) {
            for (PhoneContact p : this.getContactList()) {
                sb.append(p.getPhone());
                if (Utils.notBlankString(p.getComment())) {
                    sb.append(" [").append(p.getComment()).append(']');
                }
                sb.append("; ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
        }
        return sb.toString();
    }

    public List<String> toPhoneList() {
        if (this.contactList == null) {
            return Collections.emptyList();
        }
        return this.contactList.stream().filter(a -> Utils.notBlankString(a.getPhone())).map(PhoneContact::getPhone).toList();
    }

    public List<String> toUnformattedPhoneList() {
        return this.contactList == null ? Collections.emptyList() : this.contactList.stream().map(PhoneContact::toPhoneUnformatted).filter(Utils::notBlankString).toList();
    }

    public static String phoneUnformatted(String phone) {
        if (Utils.isEmptyString(phone)) {
            return "";
        }
        StringBuilder sb = null;
        int size = phone.length();
        for (int i = 0; i < size; ++i) {
            char c = phone.charAt(i);
            if (Character.isDigit(c)) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb != null) continue;
            sb = new StringBuilder(phone.length());
            for (int j = 0; j < i; ++j) {
                sb.append(phone.charAt(j));
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return phone;
    }

    public static class PhoneContact {
        private String phone = null;
        private String comment = null;

        public PhoneContact() {
        }

        public PhoneContact(String phone, String comment) {
            this.phone = phone;
            this.comment = comment;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String toPhoneUnformatted() {
            return EntityAttrPhone.phoneUnformatted(this.phone);
        }
    }
}

