/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.model.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntityAttr;
import ru.bgcrm.plugin.bgbilling.proto.model.entity.EntitySpecAttrType;
import ru.bgcrm.util.Utils;

public class EntityAttrEmail
extends EntityAttr {
    private String data;
    private List<EmailContact> contactList;
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^(.*)\\s*+\\<(.*)\\>$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);

    protected EntityAttrEmail() {
        super(EntitySpecAttrType.EMAIL);
    }

    public EntityAttrEmail(int entityId, int entitySpecAttrId) {
        super(EntitySpecAttrType.EMAIL, entityId, entitySpecAttrId);
    }

    public EntityAttrEmail(int entityId, int entitySpecAttrId, String name, String address) {
        super(EntitySpecAttrType.EMAIL, entityId, entitySpecAttrId);
        this.setContactList(Collections.singletonList(new EmailContact(name, address)));
    }

    public EntityAttrEmail addContact(String name, String address) {
        this.getContactList().add(new EmailContact(name, address));
        return this;
    }

    public String getData() {
        if (this.contactList != null) {
            return EntityAttrEmail.write(this.contactList);
        }
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
        this.contactList = null;
    }

    @Deprecated
    public String getValue() {
        return this.getData();
    }

    @Deprecated
    public void setValue(String value) {
        this.setData(value);
    }

    public String toString() {
        String value = this.contactList != null ? EntityAttrEmail.write(this.contactList) : this.data;
        return value == null ? "" : value.replaceAll("\n", "; ");
    }

    private static List<EmailContact> read(String value) {
        ArrayList<EmailContact> result = new ArrayList<EmailContact>(4);
        if (Utils.isBlankString(value)) {
            return result;
        }
        for (String email : value.split("\n")) {
            if (email.trim().isEmpty()) continue;
            EmailContact emailData = new EmailContact();
            Matcher matcher = FORMAT_PATTERN.matcher(email);
            if (matcher.matches()) {
                emailData.setAddress(matcher.group(2).trim());
                emailData.setName(matcher.group(1).trim());
            } else {
                emailData.setAddress(email.trim());
                emailData.setName("");
            }
            result.add(emailData);
        }
        return result;
    }

    private static String write(List<EmailContact> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(60);
        for (EmailContact contact : list) {
            if (Utils.isBlankString(contact.getAddress())) continue;
            if (Utils.notBlankString(contact.getName())) {
                sb.append(contact.getName().trim()).append(' ');
            }
            sb.append('<').append(contact.getAddress()).append('>').append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public List<EmailContact> getContactList() {
        if (this.contactList == null) {
            this.contactList = EntityAttrEmail.read(this.data);
            this.data = null;
        }
        return this.contactList;
    }

    public EntityAttrEmail setContactList(List<EmailContact> list) {
        this.contactList = list == null || list.size() == 0 ? new ArrayList<EmailContact>(2) : new ArrayList<EmailContact>(list);
        this.data = null;
        return this;
    }

    public List<String> getSimpleContactList() {
        ArrayList<String> result = new ArrayList<String>(5);
        List<EmailContact> list = this.getContactList();
        if (list == null || list.size() == 0) {
            return result;
        }
        StringBuilder sb = new StringBuilder(60);
        for (EmailContact contact : list) {
            if (Utils.notBlankString(contact.getName())) {
                sb.append(contact.getName()).append(' ');
            }
            sb.append('<').append(contact.getAddress()).append('>');
            result.add(sb.toString());
            sb.setLength(0);
        }
        return result;
    }

    public List<String> getAddressList() {
        List<EmailContact> list = this.getContactList();
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (EmailContact contact : list) {
            result.add(contact.getAddress());
        }
        return result;
    }

    public static EntityAttrEmail parse(int entityId, int entitySpecAttrId, String value) {
        EntityAttrEmail result = new EntityAttrEmail(entityId, entitySpecAttrId);
        result.data = value;
        return result;
    }

    public static class EmailContact {
        private String name;
        private String address;

        public EmailContact() {
        }

        public EmailContact(String name, String address) {
            this.name = name;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String toString() {
            return (String)(this.name != null ? this.name + " " : "") + "<" + this.address + ">";
        }
    }
}

