/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.model.FileData;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.BGServerFile;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdMessage;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdTopic;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class HelpDeskDAO
extends BillingDAO {
    private static final String MODULE = "ru.bitel.bgbilling.plugins.helpdesk";
    public static final String MODE_OFF = "off";
    public static final String MODE_ON = "on";
    public static final String MODE_PACKAGE = "package";

    public HelpDeskDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public Pair<HdTopic, List<HdMessage>> getTopicWithMessages(int topicId) {
        Pair result = null;
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("GetTopicMessage");
        req.setAttribute("topicId", topicId);
        Document doc = this.transferData.postData(req, this.user);
        Element topicEl = XMLUtils.selectElement(doc, "/data/topic");
        if (topicEl != null) {
            HdTopic topic = new HdTopic();
            topic.setId(topicId);
            topic.setClosed(Utils.parseBoolean(topicEl.getAttribute("state")));
            topic.setUserId(Utils.parseInt(topicEl.getAttribute("userId")));
            topic.setStatusId(Utils.parseInt(topicEl.getAttribute("status")));
            topic.setCost(Utils.parseBigDecimal(topicEl.getAttribute("cost")));
            topic.setAutoClose(Utils.parseBoolean(topicEl.getAttribute("autoclose")));
            topic.setInPackage(Utils.parseInt(topicEl.getAttribute("packageId")) > 0);
            ArrayList<HdMessage> list = new ArrayList<HdMessage>();
            for (Element rowEl : XMLUtils.selectElements(doc, "/data/table/data/row")) {
                list.add(this.parseHdMessage(rowEl));
            }
            result = new Pair(topic, list);
        }
        return result;
    }

    private HdMessage parseHdMessage(Element messageEl) {
        HdMessage msg = new HdMessage();
        msg.setId(Utils.parseInt(messageEl.getAttribute("id")));
        msg.setTimeFrom(TimeUtils.parse(messageEl.getAttribute("fromDateTime"), "dd.MM.yyyy HH:mm:ss"));
        msg.setUserIdFrom(Utils.parseInt(messageEl.getAttribute("fromUserId")));
        msg.setTimeTo(TimeUtils.parse(messageEl.getAttribute("toDateTime"), "dd.MM.yyyy HH:mm:ss"));
        msg.setUserIdTo(Utils.parseInt(messageEl.getAttribute("toUserId")));
        if (messageEl.getAttribute("type").equals("\u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0435")) {
            msg.setDirection(1);
        } else {
            msg.setDirection(2);
        }
        return msg;
    }

    public void updateMessage(int topicId, HdMessage msg) {
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("UpdateMessage");
        if (msg.getId() > 0) {
            req.setAttribute("id", msg.getId());
        } else {
            req.setAttribute("id", "new");
        }
        req.setAttribute("topicId", topicId);
        req.setAttribute("body", msg.getText());
        Document doc = this.transferData.postData(req, this.user);
        Element messageEl = XMLUtils.selectElement(doc, "/data/message");
        if (messageEl != null) {
            msg.setId(Utils.parseInt(messageEl.getAttribute("id")));
        }
    }

    public HdMessage getMessage(int topicId, int messageId) {
        HdMessage result = null;
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("GetMessage");
        req.setAttribute("topicId", topicId);
        req.setAttribute("id", messageId);
        Document doc = this.transferData.postData(req, this.user);
        Element messageEl = XMLUtils.selectElement(doc, "/data/message");
        if (messageEl != null) {
            result = new HdMessage();
            result.setId(messageId);
            result.setUserIdFrom(Utils.parseInt(messageEl.getAttribute("userIdFrom")));
            result.setUserIdTo(Utils.parseInt(messageEl.getAttribute("userIdTo")));
            result.setTimeFrom(TimeUtils.parse(messageEl.getAttribute("dateFrom"), "dd.MM.yyyy HH:mm:ss"));
            result.setTimeTo(TimeUtils.parse(messageEl.getAttribute("dateTo"), "dd.MM.yyyy HH:mm:ss"));
            Element bodyEl = XMLUtils.selectElement(messageEl, "body");
            if (bodyEl != null) {
                result.setText(this.linesToString(bodyEl));
            }
            for (Element fileEl : XMLUtils.selectElements(messageEl, "/data/files/data/row")) {
                result.addAttach(new FileData(Utils.parseInt(fileEl.getAttribute("id")), fileEl.getAttribute("title"), fileEl.getAttribute("size")));
            }
        }
        return result;
    }

    public void searchTopicsWithMessages(Pageable<Pair<HdTopic, List<HdMessage>>> result, int topicId) {
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("GetTopics");
        req.setAttribute("onlynew", 0);
        req.setAttribute("closed", 0);
        req.setAttribute("pageSize", 200000);
        if (topicId > 0) {
            req.setAttribute("tid", topicId);
        }
        Document doc = this.transferData.postData(req, this.user);
        for (Element topicEl : XMLUtils.selectElements(doc, "/data//topic")) {
            HdTopic topic = new HdTopic();
            topic.setId(Utils.parseInt(topicEl.getAttribute("id")));
            topic.setTitle(topicEl.getAttribute("subject"));
            topic.setStatusId(Utils.parseInt(topicEl.getAttribute("statusId")));
            topic.setCost(Utils.parseBigDecimal(topicEl.getAttribute("cost")));
            topic.setUserId(Utils.parseInt(topicEl.getAttribute("userId")));
            topic.setContractId(Utils.parseInt(topicEl.getAttribute("cid")));
            topic.setContractTitle(topicEl.getAttribute("contract"));
            topic.setLastMessageTime(TimeUtils.parse(topicEl.getAttribute("lastmessage"), "dd.MM.yyyy HH:mm:ss"));
            topic.setContact(topicEl.getAttribute("comm"));
            ArrayList<HdMessage> messages = new ArrayList<HdMessage>();
            for (Element messageEl : XMLUtils.selectElements(topicEl, "message")) {
                messages.add(this.parseHdMessage(messageEl));
            }
            result.getList().add(new Pair(topic, messages));
        }
    }

    public void markMessageRead(int messageId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "messageAdminReadSet");
            req.setParam("messageId", messageId);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("SetReadMessage");
            req.setAttribute("id", messageId);
            req.setAttribute("read", true);
            this.transferData.postData(req, this.user);
        }
    }

    public void setTopicState(int topicId, boolean stateClose) {
        Pair<HdTopic, List<HdMessage>> topic = this.getTopicWithMessages(topicId);
        if (topic.getFirst() == null) {
            throw new BGException("\u0422\u0435\u043c\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430:" + topicId, new Object[0]);
        }
        if (topic.getFirst().isClosed() == stateClose) {
            return;
        }
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "topicStateUpdate");
            req.setParam("topicId", topicId);
            req.setParam("state", stateClose);
            req.setParam("packageMode", false);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("SetTopicState");
            req.setAttribute("id", topicId);
            req.setAttribute("packetMode", 0);
            req.setAttribute("state", stateClose);
            this.transferData.postData(req, this.user);
        }
    }

    public void setTopicExecutor(int topicId, int billingUserId) {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "topicBindSet");
            req.setParam("topicId", topicId);
            req.setParam("userId", billingUserId);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("ChangeManager");
            req.setAttribute("topicId", topicId);
            req.setAttribute("manager", billingUserId);
            this.transferData.postData(req, this.user);
        }
    }

    public void setTopicExecutorMe(int topicId) {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "topicBindSet");
            req.setParam("topicId", topicId);
            req.setParam("userId", "me");
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("SetBindTopic");
            req.setAttribute("id", topicId);
            req.setAttribute("userId", "me");
            this.transferData.postData(req, this.user);
        }
    }

    public void setTopicStatus(int contractId, int topicId, int status) {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "topicStatusUpdate");
            req.setParam("topicId", topicId);
            req.setParam("status", status);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("SetTopicStatus");
            req.setContractId(contractId);
            req.setAttribute("id", topicId);
            req.setAttribute("status", status);
            this.transferData.postData(req, this.user);
        }
    }

    public void setTopicAutoClose(int contractId, int topicId, boolean value) {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "topicAutocloseUpdate");
            req.setParam("topicId", topicId);
            req.setParam("autoclose", value);
            this.transferData.postData(req, this.user);
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("SetTopicAutoclose");
            req.setContractId(contractId);
            req.setAttribute("id", topicId);
            req.setAttribute("value", value);
            this.transferData.postData(req, this.user);
        }
    }

    public void setTopicCost(int contractId, int topicId, BigDecimal cost) {
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("ApplyTopicCost");
        req.setContractId(contractId);
        req.setAttribute("topicId", topicId);
        req.setAttribute("cost", Utils.format(cost));
        this.transferData.postData(req, this.user);
    }

    public void setTopicPackageState(int contractId, int topicId, boolean inPackage) {
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("SetTopicPackageState");
        req.setContractId(contractId);
        req.setAttribute("id", topicId);
        req.setAttribute("include", String.valueOf(inPackage));
        this.transferData.postData(req, this.user);
    }

    public byte[] getAttach(int contractId, int id) throws Exception {
        byte[] result = null;
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskService", "fileDownload");
            req.setParamContractId(contractId);
            req.setParam("fileId", id);
            if (this.dbInfo.versionCompare("9.2") >= 0) {
                JsonNode node = this.transferData.postDataReturn(req, this.user);
                result = Base64.getDecoder().decode(node.path("data").textValue());
            } else {
                JsonNode node = this.transferData.postData(req, this.user);
                result = Base64.getDecoder().decode(node.path("fileData").textValue());
            }
        } else {
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("FileDownload");
            req.setContractId(contractId);
            req.setAttribute("id", id);
            Document doc = this.transferData.postData(req, this.user);
            String file = XMLUtils.selectText(doc, "/data/file/filedata/text()");
            if (file != null) {
                result = Base64.getDecoder().decode(file.getBytes("ASCII"));
            }
        }
        return result;
    }

    public void putAttach(int messageId, String title, byte[] data) throws Exception {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            BGServerFile file = new BGServerFile();
            file.setDate(new Date());
            file.setSize(data.length);
            file.setOwnerId(messageId);
            file.setTitle(title);
            this.transferData.uploadFile("ru.bitel.bgbilling.plugins.helpdesk/uploadHelpdeskFile", file, new ByteArrayInputStream(data), this.user);
        } else {
            if (this.dbInfo.versionCompare("6.2") >= 0) {
                throw new UnsupportedOperationException("\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0439.");
            }
            Request req = new Request();
            req.setModule(MODULE);
            req.setAction("FileUpload");
            req.setAttribute("id", messageId);
            req.setAttribute("filename", title);
            req.setAttribute("size", data.length);
            req.setAttribute("filedata", new String(Base64.getEncoder().encode(data), "ASCII"));
            req.setAttribute("comment", "");
            this.transferData.postData(req, this.user);
        }
    }

    public String getContractMode(int contractId) {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(MODULE, "HelpdeskParamService", "getContractCurrentMode");
            req.setParamContractId(contractId);
            return this.transferData.postDataReturn(req, this.user).asText();
        }
        Request req = new Request();
        req.setModule(MODULE);
        req.setAction("GetContractMode");
        req.setContractId(contractId);
        Document doc = this.transferData.postData(req, this.user);
        return XMLUtils.selectText(doc, "/data/modes/@current");
    }
}

