/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.UserInfo;
import ru.bgcrm.plugin.bgbilling.proto.model.status.ContractStatus;
import ru.bgcrm.plugin.bgbilling.proto.model.status.ContractStatusLogItem;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ContractStatusDAO
extends BillingDAO {
    private static final String CONTRACT_STATUS_MODULE_ID = "ru.bitel.bgbilling.kernel.contract.status";
    private static final String MODULE = "contract.status";

    public ContractStatusDAO(User user, String billingId) {
        super(user, billingId);
    }

    public ContractStatusDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public List<ContractStatus> statusList(int contractId, Map<Integer, String> statusTitleMap) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractStatusService", "contractStatusList");
            req.setParam("contractId", contractId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            List result = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractStatus.class));
            result.forEach(item -> item.setStatus((String)((Object)statusTitleMap.getOrDefault(Utils.parseInt(item.getStatus()), "??? " + item.getStatus()))));
            result.sort((item1, item2) -> item2.getId() - item1.getId());
            return result;
        }
        ArrayList<ContractStatus> statusList = new ArrayList<ContractStatus>();
        Request request = new Request();
        request.setModule(MODULE);
        request.setAction("ContractStatusTable");
        request.setContractId(contractId);
        Document doc = this.transferData.postData(request, this.user);
        for (Element element : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            ContractStatus status = new ContractStatus();
            this.loadContractStatusLogItem(element, status);
            statusList.add(status);
        }
        return statusList;
    }

    public List<ContractStatusLogItem> statusLog(int contractId, Map<Integer, String> statusTitleMap) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractStatusService", "contractStatusLogSearch");
            req.setParam("contractId", contractId);
            req.setParam("objectId", 0);
            req.setParam("page", new Page());
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            List result = (List)this.readJsonValue(ret.findValue("list").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractStatusLogItem.class));
            Map<Integer, UserInfo> userMap = new DirectoryDAO(this.user, this.dbInfo).getUsersInfo();
            result.forEach(item -> {
                item.setStatus((String)((Object)statusTitleMap.getOrDefault(Utils.parseInt(item.getStatus()), "??? " + item.getStatus())));
                UserInfo user = (UserInfo)userMap.get(item.getUserId());
                item.setUser((String)(user != null ? user.getName() : "??? " + item.getUserId()));
            });
            result.sort((item1, item2) -> item2.getId() - item1.getId());
            return result;
        }
        ArrayList<ContractStatusLogItem> result = new ArrayList<ContractStatusLogItem>();
        Request request = new Request();
        request.setModule(MODULE);
        request.setAction("ContractStatusLog");
        request.setContractId(contractId);
        Document doc = this.transferData.postData(request, this.user);
        for (Element element : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            ContractStatusLogItem status = new ContractStatusLogItem();
            this.loadContractStatusLogItem(element, status);
            status.setDate(TimeUtils.parse(element.getAttribute("date"), "dd.MM.yyyy HH:mm:ss"));
            status.setUser(element.getAttribute("user"));
            result.add(status);
        }
        return result;
    }

    private void loadContractStatusLogItem(Element element, ContractStatus status) {
        status.setId(Utils.parseInt(element.getAttribute("id")));
        status.setComment(element.getAttribute("comment"));
        status.setStatus(element.getAttribute("status"));
        TimeUtils.parsePeriod(element.getAttribute("period"), status);
    }

    public void updateStatus(int contractId, int statusId, Date dateFrom, Date dateTo, String comment) {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractStatusService", "changeContractStatus");
            if (this.dbInfo.versionCompare("9.2") >= 0) {
                req.setParam("contractId", Collections.singletonList(contractId));
                req.setParam("objectId", 0);
            } else {
                req.setParam("cid", Collections.singletonList(contractId));
            }
            req.setParam("statusId", statusId);
            req.setParam("dateFrom", dateFrom);
            req.setParam("dateTo", dateTo);
            req.setParam("comment", comment);
            req.setParam("confirmChecked", true);
            this.transferData.postDataReturn(req, this.user);
        } else {
            RequestJsonRpc req = new RequestJsonRpc(CONTRACT_STATUS_MODULE_ID, "ContractStatusMonitorService", "changeContractStatus");
            req.setParam("cid", Collections.singletonList(contractId));
            req.setParam("statusId", statusId);
            req.setParam("dateFrom", dateFrom);
            req.setParam("dateTo", dateTo);
            req.setParam("comment", comment);
            req.setParam("confirmChecked", true);
            this.transferData.postDataReturn(req, this.user);
        }
    }
}

