/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bgerp.app.exception.BGException;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.TransferData;
import ru.bgcrm.plugin.bgbilling.proto.model.BillingUser;

public class AdminDAO {
    private static final String BGSECURE_MODULE_ID = "admin.bgsecure";
    protected User user;
    protected DBInfo dbInfo;
    protected TransferData transferData;

    public AdminDAO(User user, String billingId) throws BGException {
        this.user = user;
        this.dbInfo = DBInfoManager.getInstance().getDbInfoMap().get(billingId);
        if (this.dbInfo == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0438\u043b\u043b\u0438\u043d\u0433: " + billingId, new Object[0]);
        }
        this.init();
    }

    public AdminDAO(User user, DBInfo dbInfo) throws BGException {
        this.user = user;
        this.dbInfo = dbInfo;
        this.init();
    }

    private static String getMD5Hash(String plaintext) throws BGException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BGException("NoSuchAlgorithmException - MD5", new Object[0]);
        }
        md.reset();
        md.update(plaintext.getBytes());
        byte[] digest = md.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        Object hashtext = bigInt.toString(16);
        while (((String)hashtext).length() < 32) {
            hashtext = "0" + (String)hashtext;
        }
        return hashtext;
    }

    private void init() throws BGException {
        try {
            this.transferData = this.dbInfo.getTransferData();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public void UpdateUser(BillingUser bgUser, String user_pswd) throws BGException {
        Request request = new Request();
        request.setModule(BGSECURE_MODULE_ID);
        request.setAction("UpdateUser");
        request.setAttribute("id", bgUser.getId());
        request.setAttribute("user_pswd", AdminDAO.getMD5Hash(user_pswd).toUpperCase());
        request.setAttribute("status", 0);
        request.setAttribute("contractPid", 0);
        request.setAttribute("contractGroupsMode", 0);
        request.setAttribute("name", bgUser.getName());
        request.setAttribute("login", bgUser.getLogin());
        request.setAttribute("contractGroups", 0);
        request.setAttribute("descr", bgUser.getDescribe());
        request.setAttribute("contractCid", "");
        request.setAttribute("email", "");
        request.setAttribute("pids", "");
        request.setAttribute("config", "");
        request.setAttribute("actions", "");
        this.transferData.postData(request, this.user);
    }
}

