/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.event.listener;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.cache.UserCache;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.client.ProcessChangedEvent;
import ru.bgcrm.event.process.ProcessChangingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.message.MessageTypeHelpDesk;
import ru.bgcrm.plugin.bgbilling.proto.dao.HelpDeskDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdMessage;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdTopic;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class HelpDeskListener {
    public HelpDeskListener() {
        EventProcessor.subscribe(new EventListener<ProcessChangingEvent>(){

            @Override
            public void notify(ProcessChangingEvent e, ConnectionSet connectionSet) throws Exception {
                HelpDeskListener.this.processChanged(e, connectionSet);
            }
        }, ProcessChangingEvent.class);
        EventProcessor.subscribe(new EventListener<ParamChangedEvent>(){

            @Override
            public void notify(ParamChangedEvent e, ConnectionSet connectionSet) throws BGMessageException {
                HelpDeskListener.this.paramChanged(e, connectionSet);
            }
        }, ParamChangedEvent.class);
    }

    private void paramChanged(ParamChangedEvent e, ConnectionSet conSet) throws BGMessageException {
        HdTopic topic;
        if (!"process".equals(e.getParameter().getObjectType())) {
            return;
        }
        int paramId = e.getParameter().getId();
        Pair<MessageTypeHelpDesk, Integer> pair = this.getTypeAndTopic(conSet.getConnection(), e.getObjectId());
        if (pair == null) {
            for (MessageTypeHelpDesk mt : this.getMessageTypes()) {
                if (paramId != mt.getStatusParamId() && paramId != mt.getCostParamId()) continue;
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0432, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0441 HelpDesk \u0442\u0435\u043c\u0430\u043c\u0438.", new Object[0]);
            }
            return;
        }
        Integer topicId = pair.getSecond();
        MessageTypeHelpDesk mt = pair.getFirst();
        HelpDeskDAO hdDao = new HelpDeskDAO(e.getUser(), mt.getDbInfo());
        Pair<HdTopic, List<HdMessage>> topicWithMessages = hdDao.getTopicWithMessages(topicId);
        HdTopic hdTopic = topic = topicWithMessages != null ? topicWithMessages.getFirst() : null;
        if (topic == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u043e\u043f\u0438\u043a HelpDesk \u0441 \u043a\u043e\u0434\u043e\u043c: " + topicId, new Object[0]);
        }
        String mode = hdDao.getContractMode(topic.getContractId());
        if (paramId == mt.getStatusParamId()) {
            hdDao.setTopicStatus(topic.getContractId(), topicId, (Integer)Utils.getFirst((Set)e.getValue()));
        } else if (paramId == mt.getAutoCloseParamId()) {
            hdDao.setTopicAutoClose(topic.getContractId(), topicId, ((Set)e.getValue()).size() > 0);
        } else if (paramId == mt.getCostParamId()) {
            if ("package".equals(mode)) {
                throw new BGMessageExceptionWithoutL10n("\u0420\u0435\u0436\u0438\u043c HelpDesk \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0430\u043a\u0435\u0442\u043d\u044b\u0439.", new Object[0]);
            }
            hdDao.setTopicCost(topic.getContractId(), topicId, Utils.parseBigDecimal((String)e.getValue(), BigDecimal.ZERO));
        } else if (paramId == mt.getPackageParamId()) {
            if ("on".equals(mode)) {
                throw new BGMessageExceptionWithoutL10n("\u0420\u0435\u0436\u0438\u043c HelpDesk \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043e\u0431\u044b\u0447\u043d\u044b\u0439.", new Object[0]);
            }
            hdDao.setTopicPackageState(topic.getContractId(), topicId, ((Set)e.getValue()).size() > 0);
        }
    }

    private void processChanged(ProcessChangingEvent e, ConnectionSet conSet) throws Exception {
        HelpDeskDAO hdDao;
        Pair<MessageTypeHelpDesk, Integer> pair;
        if (e.isOpening() || e.isClosing()) {
            pair = this.getTypeAndTopic(conSet.getConnection(), e.getProcess().getId());
            if (pair != null) {
                new HelpDeskDAO(e.getUser(), pair.getFirst().getDbInfo()).setTopicState(pair.getSecond(), e.isClosing());
            }
        } else if (e.isExecutors() && (pair = this.getTypeAndTopic(conSet.getConnection(), e.getProcess().getId())) != null) {
            Set<Integer> executors = ProcessExecutor.getExecutorsWithRole(e.getProcessExecutors(), 0);
            if (executors.size() > 1) {
                throw new BGMessageException("\u0414\u043b\u044f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0441 HelpDesk \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044f \u0441 \u0440\u043e\u043b\u044c\u044e 0.", new Object[0]);
            }
            User user = null;
            Integer userId = Utils.getFirst(executors);
            if (userId != null) {
                user = UserCache.getUser(userId);
            }
            hdDao = new HelpDeskDAO(e.getUser(), pair.getFirst().getDbInfo());
            if (user == null) {
                hdDao.setTopicExecutor(pair.getSecond(), 0);
            } else if (user.getId() == e.getUser().getId()) {
                hdDao.setTopicExecutorMe(pair.getSecond());
            } else {
                int billingUserId = pair.getFirst().getDbInfo().getBillingUserId(user);
                if (billingUserId <= 0) {
                    throw new BGException("\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044e " + user.getTitle() + " \u043d\u0435 \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430.", new Object[0]);
                }
                hdDao.setTopicExecutor(pair.getSecond(), billingUserId);
            }
        }
        if (e.isStatus() && (pair = this.getTypeAndTopic(conSet.getConnection(), e.getProcess().getId())) != null) {
            MessageTypeHelpDesk mt = pair.getFirst();
            if (mt.getMarkMessagesReadStatusIds().contains(e.getStatusChange().getStatusId())) {
                MessageDAO messageDao = new MessageDAO(conSet.getConnection());
                Pageable<Message> searchResult = new Pageable<Message>();
                messageDao.searchMessageList(searchResult, e.getProcess().getId(), mt.getId(), 1, null, null, null, null, null);
                hdDao = new HelpDeskDAO(e.getUser(), mt.getDbInfo());
                for (Message msg : searchResult.getList()) {
                    if (msg.getToTime() != null) continue;
                    hdDao.markMessageRead(Utils.parseInt(msg.getSystemId()));
                    msg.setToTime(new Date());
                    msg.setUserId(e.getUser().getId());
                    messageDao.updateMessageProcess(msg);
                }
            }
            e.getForm().getResponse().addEvent(new ProcessChangedEvent(e.getProcess().getId()));
        }
    }

    private Pair<MessageTypeHelpDesk, Integer> getTypeAndTopic(Connection con, int processId) {
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        List<CommonObjectLink> linkList = linkDao.getObjectLinksWithType(processId, "bgbilling-helpdesk%");
        if (linkList.size() > 0) {
            Set<MessageTypeHelpDesk> messageTypes = this.getMessageTypes();
            for (MessageTypeHelpDesk mt : messageTypes) {
                for (CommonObjectLink link : linkList) {
                    if (!link.getLinkObjectType().equals(mt.getObjectType())) continue;
                    return new Pair<MessageTypeHelpDesk, Integer>(mt, link.getLinkObjectId());
                }
            }
        }
        return null;
    }

    private Set<MessageTypeHelpDesk> getMessageTypes() {
        HashSet<MessageTypeHelpDesk> result = new HashSet<MessageTypeHelpDesk>();
        MessageTypeConfig config = Setup.getSetup().getConfig(MessageTypeConfig.class);
        for (MessageType type : config.getTypeMap().values()) {
            if (!(type instanceof MessageTypeHelpDesk)) continue;
            result.add((MessageTypeHelpDesk)type);
        }
        return result;
    }
}

