/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.creator;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import org.bgerp.util.sql.LikePattern;
import org.bgerp.util.text.LevenshteinDistance;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.dao.CustomerDAO;
import ru.bgcrm.dao.CustomerLinkDAO;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.ParamList;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.TransferData;
import ru.bgcrm.plugin.bgbilling.creator.Config;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamAddressValue;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.AddressUtils;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;
import ru.bgcrm.util.sql.SingleConnectionSet;

public class ServerCustomerCreator {
    private static final Log log = Log.getLog();
    private Config config;
    private final DBInfo dbInfo;
    private final TransferData transferData;
    private final User user;
    private final int customerIdParam;
    private final int pageSize;
    private final int minCustomerTitleLength;
    private final String billingId;
    private Map<Parameter, ParamMappingValue> paramTypeMapping = new HashMap<Parameter, ParamMappingValue>();
    private Connection con;
    private CustomerDAO customerDao;
    private ParamValueDAO paramValueDao;
    private CustomerLinkDAO linkDao;

    public ServerCustomerCreator(Config config, ConfigMap params) {
        this.config = config;
        this.billingId = params.get("billingId");
        this.dbInfo = DBInfoManager.getInstance().getDbInfoMap().get(this.billingId);
        if (this.dbInfo == null) {
            throw new BGException("Billing not defined for creator.", new Object[0]);
        }
        String userName = params.get("user", "");
        String userPassword = params.get("pswd", "");
        if (Utils.isBlankString(userName) || Utils.isBlankString(userPassword)) {
            throw new BGException("Billing user or password undefined.", new Object[0]);
        }
        this.user = new User();
        this.user.setLogin(userName);
        this.user.setPassword(userPassword);
        log.info("Creating server creator for: {}", this.dbInfo.getId());
        try {
            this.transferData = this.dbInfo.getTransferData();
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), e);
        }
        for (String token : params.get("paramMapping", "").split(";")) {
            Parameter param;
            String billingListValues;
            String[] pair = token.split(":");
            if (pair.length != 2) {
                throw new BGException("Incorrect param map: {}", token);
            }
            String crmParam = pair[0].trim();
            String billingParam = pair[1].trim();
            ParamMappingValue value = new ParamMappingValue();
            String crmListValues = StringUtils.substringBetween((String)crmParam, (String)"[", (String)"]");
            if (Utils.notBlankString(crmListValues)) {
                crmParam = StringUtils.substringBefore((String)crmParam, (String)"[");
                value.crmListValues = Utils.toIntegerList(crmListValues);
            }
            if (Utils.notBlankString(billingListValues = StringUtils.substringBetween((String)billingParam, (String)"[", (String)"]"))) {
                billingParam = StringUtils.substringBefore((String)billingParam, (String)"[");
                value.billingListValues = Utils.toIntegerList(billingListValues);
            }
            if ((param = ParameterCache.getParameter(Utils.parseInt(crmParam))) == null) {
                throw new BGException("Can't find param: {}", crmParam);
            }
            value.billingParamIdList = Utils.toIntegerList(billingParam);
            log.info("Param mapping: {} => {}", param.getId(), value.billingParamIdList);
            this.paramTypeMapping.put(param, value);
        }
        this.customerIdParam = this.dbInfo.getCustomerIdParam();
        if (this.customerIdParam <= 0) {
            throw new BGException("customerIdParam not defined for billing server!", new Object[0]);
        }
        this.pageSize = params.getInt("pageSize", 50);
        this.minCustomerTitleLength = params.getInt("minCustomerTitleLength", 10);
    }

    public String getBillingId() {
        return this.billingId;
    }

    private void init(Connection con) {
        this.con = con;
        this.customerDao = new CustomerDAO(con);
        this.paramValueDao = new ParamValueDAO(con);
        this.linkDao = new CustomerLinkDAO(con);
    }

    public void createCustomer(String billingId, Connection con, int contractId, int customerId) throws BGMessageException {
        try {
            this.init(con);
            Contract contract = new ContractDAO(this.user, billingId).getContractById(contractId);
            if (contract != null) {
                this.createCustomer(contractId, contract.getTitle(), contract.getComment());
            }
            SQLUtils.commitConnection(con);
        }
        catch (BGException | BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public void createCustomers(Connection con) {
        this.init(con);
        Request req = new Request();
        req.setModule("contract");
        req.setAction("FindContract");
        req.setAttribute("type", 1);
        req.setAttribute("parameters", this.customerIdParam);
        req.setAttribute("parameter", "^0$");
        req.setPageIndex(1);
        req.setPageSize(this.pageSize);
        log.info("Import customers for server: {}", this.dbInfo.getId());
        try {
            Document doc = this.transferData.postData(req, this.user);
            for (Element contract : XMLUtils.selectElements(doc, "/data/contracts/item")) {
                int contractId = Utils.parseInt(contract.getAttribute("id"));
                String title = contract.getAttribute("title");
                int pos = title.indexOf(91);
                String contractNumber = title.substring(0, pos).trim();
                String customerTitle = title.substring(pos + 1, title.lastIndexOf(93)).trim();
                this.createCustomer(contractId, contractNumber, customerTitle);
            }
        }
        catch (BGException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public void createCustomer(int contractId, String contractNumber, String customerTitle) throws Exception {
        log.info("FOUND CONTRACT: {}, ID: {}, customerTitle: {}", contractNumber, contractId, customerTitle);
        if (customerTitle.length() < this.minCustomerTitleLength) {
            log.warn("Customer title length less when: {}", this.minCustomerTitleLength);
            ContractParamDAO contractParamDAO = new ContractParamDAO(this.user, this.dbInfo);
            contractParamDAO.updateTextParameter(contractId, this.dbInfo.getCustomerIdParam(), "");
            return;
        }
        Pageable<Customer> result = new Pageable<Customer>();
        this.customerDao.searchCustomerList(result, LikePattern.SUB.get(customerTitle));
        Map<Integer, String> paramValues = this.getContractParamValues(contractId);
        Customer customer = this.findCustomerByTitleWithParamsConfirm(customerTitle, contractId, paramValues);
        if (customer != null) {
            log.info("Found customer by title and confirm: {}", customer.getId());
        }
        if (customer == null) {
            customer = this.findCustomerByParamsWithTitleConfirm(customerTitle, contractId, paramValues);
            if (customer == null) {
                customer = new Customer();
                customer.setTitle(customerTitle);
                customer.setTitlePattern("");
                Config.ParameterGroupTitlePatternRule rule = this.config.getCustomerParameterGroup(contractNumber);
                if (rule != null) {
                    customer.setParamGroupId(rule.parameterGroupId);
                    customer.setTitlePatternId(rule.titlePatternId);
                }
                this.customerDao.updateCustomer(customer);
                log.info("Created new customer. ID: {}; parameterGroupId: {}", customer.getId(), customer.getParamGroupId());
            } else {
                customer.setTitle(customer.getTitle() + " | " + customerTitle);
                this.customerDao.updateCustomer(customer);
                log.info("Found customer by param and title: {}", customer.getId());
            }
        }
        this.linkCustomer(customer, contractId, contractNumber, paramValues);
        SQLUtils.commitConnection(this.con);
    }

    private Map<Integer, String> getContractParamValues(int contractId) throws Exception {
        log.info("Load contract parameters.", new Object[0]);
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        ContractParamDAO contractParamDAO = new ContractParamDAO(this.user, this.dbInfo);
        Document doc = contractParamDAO.getContractParams(contractId);
        for (Element param : XMLUtils.selectElements(doc, "/data/parameters/parameter")) {
            int type = Utils.parseInt(param.getAttribute("pt"));
            int billingParamId = Utils.parseInt(param.getAttribute("pid"));
            String value = param.getAttribute("value").trim();
            if (Utils.isBlankString(value)) continue;
            if (type == 9) {
                value = value.replaceAll("[^\\d;]", "");
            }
            result.put(billingParamId, value);
            log.info("{} => {}", billingParamId, value);
        }
        return result;
    }

    private Customer findCustomerByTitleWithParamsConfirm(String customerTitle, int contractId, Map<Integer, String> paramValues) throws Exception {
        Pageable<Customer> result = new Pageable<Customer>();
        result.getPage().setPageSize(300);
        result.getPage().setPageIndex(1);
        this.customerDao.searchCustomerList(result, LikePattern.SUB.get(customerTitle));
        if (result.getList().size() != 0) {
            for (Customer customer : result.getList()) {
                for (Parameter param : this.config.confirmParameterList) {
                    Object val;
                    Integer paramId;
                    ParamMappingValue mapping = this.paramTypeMapping.get(param);
                    if (mapping == null) continue;
                    String billingParamValue = null;
                    Iterator<Integer> iterator = mapping.billingParamIdList.iterator();
                    while (iterator.hasNext() && (billingParamValue = paramValues.get(paramId = iterator.next())) == null) {
                    }
                    if (billingParamValue == null) continue;
                    if ("text".equals(param.getType())) {
                        val = this.paramValueDao.getParamText(customer.getId(), param.getId());
                        if (val == null || !((String)val).trim().equals(billingParamValue)) continue;
                        log.info("Confirm param, text: {}", param.getId());
                        return customer;
                    }
                    if ("address".equals(param.getType())) {
                        val = this.paramValueDao.getParamAddress(customer.getId(), param.getId()).values().iterator();
                        while (val.hasNext()) {
                            ParameterAddressValue addr = (ParameterAddressValue)val.next();
                            if (!addr.getValue().trim().equals(billingParamValue)) continue;
                            log.info("Confirm param, address: {}", param.getId());
                            return customer;
                        }
                        continue;
                    }
                    if ("phone".equals(param.getType())) {
                        HashSet<String> contractPhones = new HashSet<String>(Arrays.asList(billingParamValue.split(";")));
                        ParameterPhoneValue val2 = this.paramValueDao.getParamPhone(customer.getId(), param.getId());
                        if (val2 == null) continue;
                        for (ParameterPhoneValueItem item : val2.getItemList()) {
                            if (!contractPhones.contains(item.getPhone().trim())) continue;
                            log.info("Confirm param, phone: {}", param.getId());
                            return customer;
                        }
                        continue;
                    }
                    if (!"date".equals(param.getType()) || (val = TimeUtils.format(this.paramValueDao.getParamDate(customer.getId(), param.getId()), "ymd")) == null || !((String)val).trim().equals(billingParamValue)) continue;
                    log.info("Confirm param, date: {}", param.getId());
                    return customer;
                }
            }
        }
        return null;
    }

    private Customer findCustomerByParamsWithTitleConfirm(String customerTitle, int contractId, Map<Integer, String> paramValues) throws Exception {
        for (Parameter param : this.config.confirmParameterList) {
            ParamMappingValue mapping = this.paramTypeMapping.get(param);
            if (mapping == null) continue;
            for (int billingParamId : mapping.billingParamIdList) {
                String stringValue = paramValues.get(billingParamId);
                if (Utils.isBlankString(stringValue)) continue;
                if ("address".equals(param.getType())) {
                    ContractParamDAO contractParamDAO = new ContractParamDAO(this.user, this.dbInfo);
                    ParamAddressValue paramAddressValue = contractParamDAO.getAddressParam(contractId, billingParamId);
                    ParameterAddressValue billingAddr = ContractParamDAO.toCrmObject(paramAddressValue, this.con);
                    Pageable<ParameterSearchedObject<Customer>> searchResult = new Pageable<ParameterSearchedObject<Customer>>();
                    this.customerDao.searchCustomerListByAddress(searchResult, Collections.singletonList(param.getId()), billingAddr.getHouseId(), billingAddr.getFlat(), billingAddr.getRoom());
                    for (ParameterSearchedObject<Customer> result : searchResult.getList()) {
                        Customer customer = result.getObject();
                        String title = customer.getTitle();
                        int titleDistance = this.config.getMaxTitleDistance(param.getId());
                        if (titleDistance >= 0 && LevenshteinDistance.computeLevenshteinDistance(title, customerTitle) > titleDistance) continue;
                        return customer;
                    }
                    continue;
                }
                if ("phone".equals(param.getType())) {
                    String[] phones = stringValue.split(";");
                    Pageable<Customer> searchResult = new Pageable<Customer>();
                    this.customerDao.searchCustomerListByPhone(searchResult, Collections.singletonList(param.getId()), phones);
                    Customer customer = this.searchCustomer(searchResult, param.getId(), customerTitle);
                    if (customer == null) continue;
                    return customer;
                }
                if (!"text".equals(param.getType())) continue;
                Pageable<Customer> searchResult = new Pageable<Customer>();
                this.customerDao.searchCustomerListByText(searchResult, Collections.singletonList(param.getId()), LikePattern.SUB.get(stringValue));
                Customer customer = this.searchCustomer(searchResult, param.getId(), customerTitle);
                if (customer == null) continue;
                return customer;
            }
        }
        return null;
    }

    private Customer searchCustomer(Pageable<Customer> searchResult, int paramId, String customerTitle) {
        int titleDistance = this.config.getMaxTitleDistance(paramId);
        for (Customer customer : searchResult.getList()) {
            String title = customer.getTitle();
            if (titleDistance >= 0 && LevenshteinDistance.computeLevenshteinDistance(title, customerTitle) > titleDistance) continue;
            return customer;
        }
        return null;
    }

    private void linkCustomer(Customer customer, int contractId, String contractNumber, Map<Integer, String> paramValues) throws Exception {
        log.info("Linking contract: " + contractId + " to customer: " + customer.getId(), new Object[0]);
        CommonObjectLink link = new CommonObjectLink("customer", customer.getId(), "contract:" + this.dbInfo.getId(), contractId, contractNumber);
        this.linkDao.deleteLinksTo(link);
        EventProcessor.processEvent(new LinkAddingEvent(new DynActionForm(this.user), link), new SingleConnectionSet(this.con));
        this.linkDao.addLink(link);
        for (Parameter param : this.config.importParameterList) {
            ParamMappingValue mapping = this.paramTypeMapping.get(param);
            if (mapping == null) {
                log.info("Not found billing params for import customer param: " + param.getId(), new Object[0]);
                continue;
            }
            for (int billingParamId : mapping.billingParamIdList) {
                ContractParamDAO contractParamDAO;
                SortedMap<Integer, ParameterEmailValue> customerParamValue;
                Cloneable billingValues;
                String stringValue = paramValues.get(billingParamId);
                if (Utils.isBlankString(stringValue)) continue;
                log.info("Checking import parameter " + param.getId() + " with billing value " + stringValue, new Object[0]);
                if ("text".equals(param.getType())) {
                    this.paramValueDao.updateParamText(customer.getId(), param.getId(), stringValue);
                    log.info("Update text param: " + param.getId() + ", value: " + stringValue, new Object[0]);
                    continue;
                }
                if ("date".equals(param.getType())) {
                    Date date = TimeUtils.parse(stringValue, "ymd");
                    if (date != null) {
                        this.paramValueDao.updateParamDate(customer.getId(), param.getId(), date);
                        log.info("Update date param: " + param.getId() + ", value: " + stringValue, new Object[0]);
                        continue;
                    }
                    log.error("Incorrect date param: " + stringValue, new Object[0]);
                    continue;
                }
                if ("phone".equals(param.getType())) {
                    billingValues = new HashSet<String>(Arrays.asList(stringValue.split(";")));
                    customerParamValue = this.paramValueDao.getParamPhone(customer.getId(), param.getId());
                    if (customerParamValue != null) {
                        for (ParameterPhoneValueItem item : ((ParameterPhoneValue)((Object)customerParamValue)).getItemList()) {
                            billingValues.remove(item.getPhone());
                        }
                    } else {
                        customerParamValue = new ParameterPhoneValue();
                        ((ParameterPhoneValue)((Object)customerParamValue)).setItemList(new ArrayList<ParameterPhoneValueItem>());
                    }
                    if (billingValues.size() <= 0) continue;
                    log.info("Add phone param values, param: " + param.getId() + "; values: " + Utils.toString(billingValues), new Object[0]);
                    ContractParamDAO contractParamDAO2 = new ContractParamDAO(this.user, this.dbInfo);
                    ParameterPhoneValue parameterPhoneValue = contractParamDAO2.getPhoneParam(contractId, billingParamId);
                    for (ParameterPhoneValueItem item : parameterPhoneValue.getItemList()) {
                        if (!billingValues.contains(item.getPhone())) continue;
                        log.info("Value: {}", item.getPhone());
                        ((ParameterPhoneValue)((Object)customerParamValue)).getItemList().add(item);
                    }
                    this.paramValueDao.updateParamPhone(customer.getId(), param.getId(), (ParameterPhoneValue)((Object)customerParamValue));
                    continue;
                }
                if ("address".equals(param.getType())) {
                    ParameterAddressValue value;
                    contractParamDAO = new ContractParamDAO(this.user, this.dbInfo);
                    ParamAddressValue paramAddressValue = contractParamDAO.getAddressParam(contractId, billingParamId);
                    ParameterAddressValue billingAddr = ContractParamDAO.toCrmObject(paramAddressValue, this.con);
                    boolean addressExist = false;
                    Iterator<Object> iterator = this.paramValueDao.getParamAddress(customer.getId(), param.getId()).values().iterator();
                    while (iterator.hasNext() && !(addressExist = (value = iterator.next()).getHouseId() == billingAddr.getHouseId() && value.getFlat().equals(billingAddr.getFlat()) && value.getRoom().equals(billingAddr.getRoom()))) {
                    }
                    if (addressExist) continue;
                    billingAddr.setValue(AddressUtils.buildAddressValue(billingAddr, this.con));
                    this.paramValueDao.updateParamAddress(customer.getId(), param.getId(), 0, billingAddr);
                    log.info("Add address param value, param: " + param.getId() + "; value: " + billingAddr.getValue(), new Object[0]);
                    continue;
                }
                if ("list".equals(param.getType())) {
                    contractParamDAO = new ContractParamDAO(this.user, this.dbInfo);
                    ParamList billingValue = contractParamDAO.getListParamValue(contractId, billingParamId);
                    if (billingValue == null) continue;
                    if (mapping.billingListValues.size() > 0) {
                        int pos = mapping.billingListValues.indexOf(billingValue.getId());
                        if (pos < 0) {
                            log.error("Not found billing param list value: " + billingValue.getId(), new Object[0]);
                            continue;
                        }
                        if (pos >= mapping.crmListValues.size()) {
                            log.error("Not found crm param list value for billing value: " + billingValue.getId(), new Object[0]);
                            continue;
                        }
                        int crmListParamValue = mapping.crmListValues.get(pos);
                        Set<Integer> values = this.paramValueDao.getParamList(customer.getId(), param.getId());
                        values.add(crmListParamValue);
                        this.paramValueDao.updateParamList((int)customer.getId(), (int)param.getId(), values);
                        log.info("Add list param value, param: " + param.getId() + "; value: " + crmListParamValue, new Object[0]);
                        continue;
                    }
                    this.paramValueDao.updateParamList((int)customer.getId(), (int)param.getId(), Collections.singleton(billingValue.getId()));
                    log.info("Add list param value, param: " + param.getId() + "; value: " + billingValue.getId(), new Object[0]);
                    continue;
                }
                if (!"email".equals(param.getType())) continue;
                billingValues = new HashMap();
                for (String value : Arrays.asList(stringValue.split("[;,]"))) {
                    if (Utils.isEmptyString(value = value.trim())) continue;
                    String email = "";
                    String comment = "";
                    try {
                        InternetAddress addr = InternetAddress.parse((String)value)[0];
                        email = addr.getAddress();
                        comment = Utils.maskNull(addr.getPersonal());
                    }
                    catch (Exception e) {
                        int pos = value.indexOf(32);
                        if (pos > 0) {
                            email = value.substring(0, pos);
                            comment = value.substring(pos + 1).trim();
                        }
                        email = value;
                    }
                    billingValues.put(email, comment);
                }
                customerParamValue = this.paramValueDao.getParamEmail(customer.getId(), param.getId());
                if (customerParamValue != null) {
                    for (ParameterEmailValue item : customerParamValue.values()) {
                        billingValues.remove(item.getValue().trim());
                    }
                }
                for (Map.Entry me : billingValues.entrySet()) {
                    try {
                        this.paramValueDao.updateParamEmail(customer.getId(), param.getId(), 0, new ParameterEmailValue((String)me.getKey(), (String)me.getValue()));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        }
    }

    private static class ParamMappingValue {
        private List<Integer> billingParamIdList;
        private List<Integer> crmListValues = Collections.emptyList();
        private List<Integer> billingListValues = Collections.emptyList();

        private ParamMappingValue() {
        }
    }
}

