/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import java.util.Date;
import java.util.Map;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import ru.bgcrm.dao.expression.ExpressionContextAccessingObject;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamAddressValue;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class ExpressionObject
extends ExpressionContextAccessingObject {
    private static final Log log = Log.getLog();

    ExpressionObject() {
    }

    @Override
    public void toContext(Map<String, Object> context) {
        super.toContext(context);
        context.put("bgbilling", this);
    }

    public void cp(int contractParamId, String contractParamType, int processParamId) throws Exception {
        Process process = (Process)this.context.get("process");
        Parameter processParam = ParameterCache.getParameter(processParamId);
        if (processParam == null) {
            throw new NotFoundException("Not found parameter with ID: " + processParamId);
        }
        ConnectionSet conSet = (ConnectionSet)this.context.get("conSet");
        ProcessLinkDAO linkDao = new ProcessLinkDAO(conSet.getSlaveConnection());
        CommonObjectLink contractLink = Utils.getFirst(linkDao.getObjectLinksWithType(process.getId(), "contract%"));
        if (contractLink == null) {
            log.debug("Not found link BGBilling contract for process: {}", process.getId());
            return;
        }
        int contractId = contractLink.getLinkObjectId();
        String billingId = StringUtils.substringAfter((String)contractLink.getLinkObjectType(), (String)":");
        User user = (User)this.context.get("user");
        ContractParamDAO contractParamDao = new ContractParamDAO(user, billingId);
        ParamValueDAO paramDao = new ParamValueDAO(conSet.getConnection());
        switch (processParam.getTypeType()) {
            case ADDRESS: {
                ParamAddressValue value = contractParamDao.getAddressParam(contractId, contractParamId);
                if (value == null) break;
                paramDao.updateParamAddress(process.getId(), processParamId, 0, value.toParameterAddressValue(conSet.getSlaveConnection()));
                break;
            }
            case DATE: {
                Date value = contractParamDao.getDateParam(contractId, contractParamId);
                if (value == null) break;
                paramDao.updateParamDate(process.getId(), processParamId, value);
                break;
            }
            case BLOB: 
            case TEXT: {
                String value = null;
                if (Utils.isBlankString(contractParamType) || "text".equals(contractParamType)) {
                    value = contractParamDao.getTextParam(contractId, contractParamId);
                } else if ("address".equals(contractParamType)) {
                    value = contractParamDao.getAddressParam(contractId, contractParamId).toParameterAddressValue(conSet.getSlaveConnection()).getValue();
                } else if ("phone".equals(contractParamType)) {
                    value = contractParamDao.getPhoneParam(contractId, contractParamId).toString();
                } else {
                    this.throwException(contractParamId, contractParamType, processParamId, processParam);
                }
                if (!Utils.notBlankString(value)) break;
                if (processParam.getTypeType() == Parameter.Type.BLOB) {
                    paramDao.updateParamBlob(process.getId(), processParamId, value);
                    break;
                }
                paramDao.updateParamText(process.getId(), processParamId, value);
                break;
            }
            case PHONE: {
                ParameterPhoneValue value = contractParamDao.getPhoneParam(contractId, contractParamId);
                paramDao.updateParamPhone(process.getId(), processParamId, value);
                break;
            }
            default: {
                this.throwException(contractParamId, contractParamType, processParamId, processParam);
            }
        }
    }

    private void throwException(int contractParamId, String contractParamType, int processParamId, Parameter processParam) {
        throw new IllegalArgumentException(Log.format("Can't copy contract parameter with ID {} and type {} to process parameter with ID {} and type {}", contractParamId, contractParamType, processParamId, processParam.getType()));
    }
}

