/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.UserCache;
import org.bgerp.util.sql.pool.ConnectionPool;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.TransferData;

public class DBInfo {
    private String id;
    private String url;
    private URL serverUrl;
    private String title;
    private String version;
    private ConfigMap setup;
    private Set<String> pluginSet;
    private ConnectionPool connectionPool;
    private Map<Integer, Integer> billingUserIdCrmUserIdMap = new HashMap<Integer, Integer>();
    private ConfigMap guiConfigValues;

    public DBInfo(String id) {
        this.id = id;
        for (User user : UserCache.getUserMap().values()) {
            int billingUserId = user.getConfigMap().getInt("bgbilling:userId." + id, 0);
            if (billingUserId <= 0) continue;
            this.billingUserIdCrmUserIdMap.put(billingUserId, user.getId());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public void setUrl(String url) {
        this.url = url;
        try {
            this.serverUrl = new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new BGException(ex);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int versionCompare(String withVersion) {
        return new BigDecimal(this.version).compareTo(new BigDecimal(withVersion));
    }

    public ConfigMap getSetup() {
        return this.setup;
    }

    public void setSetup(ConfigMap setup) {
        this.setup = setup;
        this.connectionPool = new ConnectionPool("bgbilling-" + this.getId(), setup);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public int getCustomerIdParam() {
        return this.setup.getInt("customerIdParam", 0);
    }

    public Set<String> getPluginSet() {
        return this.pluginSet;
    }

    public void setPluginSet(Set<String> pluginSet) {
        this.pluginSet = pluginSet;
    }

    public ConfigMap getGuiConfigValues() {
        return this.guiConfigValues;
    }

    public void setGuiConfigValues(ConfigMap config) {
        this.guiConfigValues = config;
    }

    public TransferData getTransferData() {
        return new TransferData(this);
    }

    public String getCopyParamMapping() {
        return this.setup.get("copyParamMapping");
    }

    public int getBillingUserId(User user) {
        return user.getConfigMap().getInt("bgbilling:userId." + this.id, -1);
    }

    public int getCrmUserId(int billingUserId) {
        Integer value = this.billingUserIdCrmUserIdMap.get(billingUserId);
        return value != null ? value : -1;
    }
}

