/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.asterisk;

import java.sql.Connection;
import java.util.Date;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.StatusAction;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.model.msg.Message;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageTypeCall;
import ru.bgcrm.plugin.asterisk.ManagerConnection;
import ru.bgcrm.struts.form.DynActionForm;

public class AmiEventListener
extends Thread
implements ManagerEventListener {
    private static final Log log = Log.getLog();
    private final MessageTypeCall messageType;
    private final ConfigMap config;
    private org.asteriskjava.manager.ManagerConnection managerConnection;
    private volatile boolean run = true;

    public AmiEventListener(MessageTypeCall messageType, ConfigMap config) {
        this.messageType = messageType;
        this.config = config;
        this.start();
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                this.managerConnection = new ManagerConnection(this.config);
                this.managerConnection.addEventListener((ManagerEventListener)this);
                this.managerConnection.login();
                this.managerConnection.sendAction((ManagerAction)new StatusAction());
                AmiEventListener.sleep(300000L);
                this.managerConnection.removeEventListener((ManagerEventListener)this);
                if (this.managerConnection.getState() == ManagerConnectionState.DISCONNECTED) continue;
                this.managerConnection.logoff();
            }
            catch (Exception e) {
                log.error(e);
                try {
                    AmiEventListener.sleep(60000L);
                }
                catch (Exception ex) {
                    log.error(e);
                }
            }
        }
    }

    public void logoff() {
        this.managerConnection.removeEventListener((ManagerEventListener)this);
        this.managerConnection.logoff();
        this.run = false;
    }

    public void onManagerEvent(ManagerEvent e) {
        NewStateEvent event;
        log.debug("AMI event: {}", e);
        if (!(e instanceof NewStateEvent) || !"Up".equals((event = (NewStateEvent)e).getChannelStateDesc())) {
            return;
        }
        String numberFrom = event.getConnectedLineNum();
        String numberTo = event.getCallerIdNum();
        MessageTypeCall.CallRegistration reg = this.messageType.getRegistrationByNumber(numberTo);
        if (reg != null && reg.getMessageForOpen() == null && numberFrom != null) {
            log.info("Call to registered number: {}, event: {}", reg.getNumber(), event);
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                Message message = new Message();
                message.setDirection(1);
                message.setTypeId(this.messageType.getId());
                message.setUserId(reg.getUserId());
                message.setText("");
                message.setFrom(numberFrom);
                message.setTo(numberTo);
                message.setFromTime(new Date());
                message.setSystemId(event.getUniqueId());
                this.messageType.updateMessage(con, DynActionForm.SYSTEM_FORM, message);
                con.commit();
                log.info("Created message: {}", message.getId());
                reg.setMessageForOpen(message);
            }
            catch (Exception ex) {
                log.error(ex);
            }
        } else {
            log.debug("No registered number found, the call was already processed or there is no FROM number in the event", new Object[0]);
        }
    }
}

