/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import org.reflections.Reflections;
import ru.bgcrm.plugin.Plugin;

public class PluginManager {
    private static final Log log = Log.getLog();
    public static final String[] ERP_PACKAGES = new String[]{"org.bgerp", "ru.bgcrm"};
    private static PluginManager instance;
    private final List<Plugin> fullSortedPluginList;
    private final Map<String, Plugin> fullPluginMap;
    private final List<Plugin> pluginList;
    private final Map<String, Plugin> pluginMap;

    public static void init() throws Exception {
        instance = new PluginManager();
        instance.initPlugins();
    }

    public static PluginManager getInstance() {
        return instance;
    }

    private PluginManager() throws Exception {
        log.info("Plugins loading..", new Object[0]);
        this.fullSortedPluginList = this.loadFullSortedPluginList();
        this.fullPluginMap = Collections.unmodifiableMap(this.fullSortedPluginList.stream().collect(Collectors.toMap(Plugin::getId, p -> p)));
        this.pluginList = this.loadPlugins();
        this.pluginMap = Collections.unmodifiableMap(this.pluginList.stream().collect(Collectors.toMap(Plugin::getId, p -> p)));
    }

    private List<Plugin> loadFullSortedPluginList() {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        Reflections r = new Reflections((Object[])ERP_PACKAGES);
        for (Class pc : r.getSubTypesOf(Plugin.class)) {
            log.debug("Found plugin: {}", pc);
            try {
                Plugin instance = null;
                try {
                    instance = (Plugin)pc.getField("INSTANCE").get(null);
                }
                catch (NoSuchFieldException e) {
                    Constructor constructor = pc.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    log.warn("No INSTANCE found in: {}", pc);
                    instance = (Plugin)constructor.newInstance(new Object[0]);
                }
                result.add(instance);
            }
            catch (Exception e) {
                log.error("Error loading of plugin: " + String.valueOf(pc), e);
            }
        }
        result.sort((p1, p2) -> {
            if (p1.isSystem() && !p2.isSystem()) {
                return -1;
            }
            if (p2.isSystem() && !p1.isSystem()) {
                return 1;
            }
            return p1.getId().compareTo(p2.getId());
        });
        return Collections.unmodifiableList(result);
    }

    private List<Plugin> loadPlugins() {
        Setup setup = Setup.getSetup();
        String enabledDefault = setup.get("plugin.enable.default", "0");
        List result = this.fullSortedPluginList.stream().filter(p -> p.isEnabled(setup, enabledDefault)).collect(Collectors.toList());
        return Collections.unmodifiableList(result);
    }

    private void initPlugins() throws Exception {
        log.info("Running init() for enabled plugins.", new Object[0]);
        for (Plugin p : this.pluginList) {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                p.init(con);
                con.commit();
            }
            finally {
                if (con == null) continue;
                con.close();
            }
        }
    }

    @Dynamic
    public List<Plugin> getFullSortedPluginList() {
        return this.fullSortedPluginList;
    }

    @Dynamic
    public List<Plugin> getPluginList() {
        return this.pluginList;
    }

    @Dynamic
    public List<Plugin> getInactivePluginList() {
        Set activeIds = this.pluginList.stream().map(Plugin::getId).collect(Collectors.toSet());
        List<Plugin> result = this.fullSortedPluginList.stream().filter(p -> !activeIds.contains(p.getId()) && !p.isSystem()).collect(Collectors.toList());
        return result;
    }

    @Dynamic
    public Map<String, Plugin> getPluginMap() {
        return this.pluginMap;
    }

    public Map<String, Plugin> getFullPluginMap() {
        return this.fullPluginMap;
    }
}

