/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.dist.inst.call.ExecuteSQL;
import org.bgerp.app.dist.lic.AppLicense;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.dao.Cleaner;
import org.bgerp.plugin.msg.email.message.MessageTypeEmail;
import org.bgerp.util.Log;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.plugin.Table;
import ru.bgcrm.util.Utils;

public abstract class Plugin {
    private static final Log log = Log.getLog();
    private static final String ENABLE_KEY_SUFFIX = ":enable";
    protected static final String PATH_JS = "/js";
    protected static final String PATH_LIB = "/lib";
    protected static final String PATH_CSS = "/css";
    protected static final String PATH_JSP_ADMIN_PLUGIN = "/WEB-INF/jspf/admin/plugin";
    protected static final String PATH_JSP_USER_PLUGIN = "/WEB-INF/jspf/user/plugin";
    protected static final String PATH_JSP_OPEN_PLUGIN = "/WEB-INF/jspf/open/plugin";
    private final String id;
    @Deprecated
    private final Document document;
    private final Map<String, List<String>> endpoints;
    private final Localization localization;

    protected Plugin(String id) {
        this.id = id;
        this.document = this.getXml("plugin.xml", XMLUtils.newDocument());
        this.endpoints = this.loadEndpoints();
        this.localization = Localization.getLocalization(this);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.id.substring(0, 1).toUpperCase() + this.id.substring(1);
    }

    public final String getTitleWithPrefix() {
        return "Plugin " + this.getTitle();
    }

    public boolean isSystem() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    public Document getXml(String name, Document defaultValue) {
        InputStream is = this.getClass().getResourceAsStream(name);
        return is != null ? XMLUtils.parseDocument(is) : defaultValue;
    }

    protected Map<String, List<String>> loadEndpoints() {
        HashMap<String, List<String>> endpoints = new HashMap<String, List<String>>(20);
        if (this.document != null) {
            for (Element endpoint : XMLUtils.selectElements(this.document, "/plugin/endpoint")) {
                endpoints.put(endpoint.getAttribute("id"), Collections.singletonList(endpoint.getAttribute("file")));
            }
        }
        return Collections.unmodifiableMap(endpoints);
    }

    public String getResourcePath(String name) {
        URL resource = this.getClass().getResource(name);
        return resource != null ? this.getClass().getPackageName().replace('.', '/') + "/" + name : null;
    }

    public Set<String> getActionPackages() {
        return Set.of(this.getClass().getPackageName());
    }

    public Set<String> getDependencies() {
        return Collections.emptySet();
    }

    public final List<String> getEndpoints(String key) {
        return this.endpoints.get(key);
    }

    public Class<? extends MessageTypeEmail> getMessageTypeClass(String name) {
        return null;
    }

    public void init(Connection con) throws Exception {
        log.info("Plugin '{}', class '{}' init", this.getId(), this.getClass().getName());
        this.initDB(con);
    }

    private void initDB(Connection con) throws SQLException, IOException {
        InputStream script = this.getClass().getResourceAsStream("db.sql");
        if (script != null) {
            log.info("{} applying db.sql", this.getId());
            new ExecuteSQL().call(con, IOUtils.toString((InputStream)script, (Charset)StandardCharsets.UTF_8));
        }
    }

    public boolean isEnabled(ConfigMap config, String defaultValue) {
        boolean defaultValueBool = "lic".equals(defaultValue) ? AppLicense.instance().getPlugins().contains(this.getId()) : Utils.parseBoolean(defaultValue, false).booleanValue();
        return config.getBoolean(this.getId() + ENABLE_KEY_SUFFIX, defaultValueBool);
    }

    public Localization getLocalization() {
        return this.localization;
    }

    public Localizer getLocalizer() {
        return new Localizer(Localization.getLang(), this.getLocalization());
    }

    public Set<Table> getTables() {
        return Collections.emptySet();
    }

    public Set<String> getObjectTypes() {
        return Collections.emptySet();
    }

    public Cleaner getCleaner() {
        return null;
    }
}

