/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import ru.bgcrm.model.process.queue.MediaColumn;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.model.process.queue.config.PrintQueueConfig;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;

public class JasperReport {
    private static Font defaultFont;
    private static Font headerFont;
    private static Font titleFont;
    private static Style defaultStyle;
    private static Style titleStyle;
    private static Style headerStyle;
    private static Style descriptionStyle;
    private static Style oddRowStyle;

    public JasperReport() throws IOException {
        String fontPath = "jar:" + this.getClass().getResource("/ru/bitel/fonts/arial.ttf").getPath();
        defaultFont = new Font(8, "Serif", fontPath, "CP1251", true);
        headerFont = new Font(9, "Serif", fontPath, "CP1251", true);
        titleFont = new Font(12, "Serif", fontPath, "CP1251", true);
        defaultStyle = new Style("normalStyle");
        defaultStyle.setStretchWithOverflow(true);
        defaultStyle.setStreching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
        defaultStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        defaultStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        defaultStyle.setFont(defaultFont);
        headerStyle = new Style("headerStyle");
        headerStyle.setStretchWithOverflow(true);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setBackgroundColor(new Color(230, 230, 230));
        headerStyle.setTransparency(Transparency.OPAQUE);
        headerStyle.setFont(headerFont);
        descriptionStyle = new Style("descriptionStyle");
        descriptionStyle.setStretchWithOverflow(true);
        descriptionStyle.setStreching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
        descriptionStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        descriptionStyle.setHorizontalAlign(HorizontalAlign.LEFT);
        descriptionStyle.setFont(defaultFont);
        titleStyle = new Style("titleStyle");
        titleStyle.setStretchWithOverflow(true);
        titleStyle.setFont(titleFont);
        oddRowStyle = new Style();
        oddRowStyle.setBorder(Border.NO_BORDER());
        oddRowStyle.setBackgroundColor(new Color(235, 235, 235));
        oddRowStyle.setTransparency(Transparency.OPAQUE);
    }

    public void addPrintQueueDocumentToOutputStream(DynActionForm form, List<Object[]> data, Queue queue, PrintQueueConfig.PrintType printType, OutputStream ostream) throws Exception {
        FastReportBuilder drb = new FastReportBuilder();
        drb.setTitle(form.l.l("\u041e\u0447\u0435\u0440\u0435\u0434\u044c", new Object[0]) + " : " + queue.getTitle()).setSubtitle(form.l.l("\u0414\u0430\u0442\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438", new Object[0]) + " " + TimeUtils.format(new Date(), "ymd")).setPrintBackgroundOnOddRows(true).setOddRowBackgroundStyle(oddRowStyle).setColumnsPerPage(1).setUseFullPageWidth(true).setColumnSpace(5).setAllowDetailSplit(false).setMargins(0, 0, 0, 0).setDefaultStyles(titleStyle, titleStyle, headerStyle, defaultStyle);
        if (printType != null) {
            if (printType.getOrientation().equals("landscape")) {
                drb.setPageSizeAndOrientation(Page.Page_A4_Landscape());
            } else {
                drb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            }
        } else {
            drb.setPageSizeAndOrientation(Page.Page_A4_Landscape());
        }
        List<MediaColumn> printColumns = null;
        if (printType != null) {
            printColumns = queue.getMediaColumnList(printType.getColumnIds());
            List<Integer> widths = printType.getColumnWidths();
            for (int i = 0; i < printColumns.size(); ++i) {
                MediaColumn col = printColumns.get(i);
                Integer width = (Integer)widths.get(i);
                column = ColumnBuilder.getNew().setColumnProperty(String.valueOf(col.getColumn().getId()), String.class.getName()).setTitle(col.getColumn().getTitle()).setWidth(width.intValue()).setStyle(defaultStyle).setHeaderStyle(headerStyle).build();
                drb.addColumn(column);
            }
        } else {
            printColumns = queue.getMediaColumnList("print");
            for (MediaColumn col : printColumns) {
                int width = 50;
                Style style = defaultStyle;
                if ("description".equals(col.getColumn().getValue())) {
                    width = 300;
                    style = descriptionStyle;
                }
                column = ColumnBuilder.getNew().setColumnProperty(col.getColumn().getId(), String.class.getName()).setTitle(col.getColumn().getTitle()).setWidth(width).setStyle(style).setHeaderStyle(headerStyle).build();
                drb.addColumn(column);
            }
        }
        int size = printColumns.size();
        ArrayList jdata = new ArrayList();
        for (Object[] objects : data) {
            HashMap<String, Object> map = new HashMap<String, Object>(size);
            jdata.add(map);
            for (int i = 0; i < size; ++i) {
                MediaColumn col = printColumns.get(i);
                map.put(String.valueOf(col.getColumn().getId()), objects[i]);
            }
        }
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(jdata);
        JasperPrint jp = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)ostream);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"CP1251");
        exporter.exportReport();
    }
}

