/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.model.base.tree.TreeItem;
import ru.bgcrm.model.process.TypeProperties;

public class ProcessType
extends TreeItem<Integer, ProcessType>
implements Comparable<ProcessType> {
    private boolean useParentProperties;
    private TypeProperties properties;

    public ProcessType() {
    }

    public ProcessType(int id, String title) {
        this.id = id;
        this.title = title;
    }

    public TypeProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TypeProperties properties) {
        this.properties = properties;
    }

    public boolean isUseParentProperties() {
        return this.useParentProperties;
    }

    public void setUseParentProperties(boolean useParentProperties) {
        this.useParentProperties = useParentProperties;
    }

    @JsonIgnore
    public List<ProcessType> getPath() {
        return ProcessTypeCache.getTypePath((Integer)this.id);
    }

    public Set<Integer> getSelectedChildIds(Set<Integer> typeSet) {
        HashSet<Integer> result = new HashSet<Integer>(typeSet.size());
        for (ProcessType childItem : this.children) {
            if (result.contains(childItem.getId())) continue;
            if (typeSet.contains(childItem.getId())) {
                result.addAll(childItem.getAllChildIds());
                continue;
            }
            result.addAll(childItem.getSelectedChildIds(typeSet));
        }
        return result;
    }

    public ProcessType sub(Collection<ProcessType> typeList) {
        Set<Integer> typeSet = typeList.stream().map(TreeItem::getId).collect(Collectors.toSet());
        return this.sub(typeSet);
    }

    public ProcessType sub(Set<Integer> typeIds) {
        if (typeIds == null) {
            return this;
        }
        ProcessType result = new ProcessType();
        result.setId((Integer)this.id);
        result.setTitle(this.title);
        ArrayList<ProcessType> children = new ArrayList<ProcessType>(this.children.size());
        for (ProcessType child : this.children) {
            if (!child.isInSet(typeIds)) continue;
            children.add(child.sub(typeIds));
        }
        result.setChildren(children);
        return result;
    }

    @Override
    public int compareTo(ProcessType o) {
        return (Integer)this.id - (Integer)o.getId();
    }

    @Override
    protected boolean isRootNode() {
        return this.isRootNodeWithIntegerId((Integer)this.id, (Integer)this.parentId);
    }
}

